/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JPingDS;
import com.ibm.as400.access.JPingEchoDS;
import com.ibm.as400.access.JPingEchoReplyDS;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class AS400JPing {
    public static final int ALL_SERVICES = 99;
    private String systemName_;
    private int service_ = 99;
    private int length_ = 10;
    private boolean echo_ = false;
    private SSLOptions useSSL_ = null;
    private long time_ = 20000L;
    private PrintWriter writer_;
    private SocketContainer socketContainer_;
    private Socket ddmSocket_;
    private Thread jpingDaemon_;
    private JPingThread jpingThread_;
    private SocketProperties socketProperties_ = new SocketProperties();
    private static ResourceBundleLoader loader_;

    public AS400JPing(String systemName) {
        this(systemName, 99, false);
    }

    public AS400JPing(String systemName, int service) {
        this(systemName, service, false);
    }

    public AS400JPing(String systemName, int service, boolean useSSL) {
        if (systemName == null) {
            throw new NullPointerException("systemName");
        }
        if (service < 0 || service > 7 && service != 99) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        this.systemName_ = systemName;
        this.service_ = service;
        this.useSSL_ = useSSL ? new SSLOptions() : null;
    }

    public boolean ping() {
        if (this.service_ == 99) {
            boolean rtn = true;
            for (int i = 0; i <= 7; ++i) {
                boolean bl = rtn = rtn && this.ping(i);
                if (rtn) continue;
                return rtn;
            }
            return rtn;
        }
        return this.ping(this.service_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean ping(int service) {
        if (service < 0 || service > 7) {
            throw new ExtendedIllegalArgumentException("service (" + service + ")", 2);
        }
        int timeout = (int)this.time_;
        if (timeout > 0) {
            this.socketProperties_.setSoTimeout(timeout);
        }
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            if (Trace.traceOn_) {
                Trace.log(3, "Ping System:   " + this.systemName_);
                Trace.log(3, "Ping Service:  " + AS400.getServerName(service));
                Trace.log(3, "Packet Length: " + this.length_);
                Trace.log(3, "Echo Packet:   " + (this.echo_ ? "on" : "off"));
                Trace.log(3, "Ping SSL Port: " + (this.useSSL_ != null ? "yes" : "no"));
            }
            this.service_ = service;
            if (service == 5) {
                this.pingDDM();
            } else {
                ClientAccessDataStream req;
                this.jpingThread_ = new JPingThread();
                this.jpingDaemon_ = new Thread((Runnable)this.jpingThread_, "AS400JPingDaemon");
                this.jpingDaemon_.setDaemon(true);
                this.jpingDaemon_.start();
                AS400JPing aS400JPing = this;
                synchronized (aS400JPing) {
                    block55: {
                        try {
                            if (Trace.traceOn_) {
                                Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                            }
                            this.wait(this.time_);
                        }
                        catch (InterruptedException ie) {
                            if (!Trace.traceOn_) break block55;
                            Trace.log(2, "Unexpected exception.", (Throwable)ie);
                        }
                    }
                }
                if (this.socketContainer_ == null) {
                    this.jpingDaemon_.interrupt();
                    throw new Exception("Ping timeout occurred.");
                }
                inStream = this.socketContainer_.getInputStream();
                outStream = this.socketContainer_.getOutputStream();
                byte[] buffer = new byte[this.length_];
                for (int i = 0; i < this.length_; ++i) {
                    buffer[i] = -35;
                }
                if (this.echo_) {
                    req = new JPingEchoDS(service, buffer);
                    req.write(outStream);
                    outStream.flush();
                    JPingEchoReplyDS reply = new JPingEchoReplyDS(buffer.length);
                    if (reply.read(inStream) != this.length_) {
                        Trace.log(2, "Bytes echoed did not match then number of bytes sent.");
                        throw new ConnectionDroppedException(2);
                    }
                } else {
                    req = new JPingDS(service, buffer);
                    req.write(outStream);
                    outStream.flush();
                }
            }
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_SUCCESS"), new String[]{AS400.getServerName(service), this.useSSL_ != null ? "-s" : ""}));
            }
            boolean buffer = true;
            return buffer;
        }
        catch (ServerStartupException sse) {
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(service), this.useSSL_ != null ? "-s" : ""}));
            }
            if (Trace.traceOn_) {
                Trace.log(2, sse);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(service), this.useSSL_ != null ? "-s" : ""}));
            }
            if (Trace.traceOn_) {
                Trace.log(2, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
            if (this.socketContainer_ != null) {
                try {
                    this.socketContainer_.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
        }
    }

    public boolean pingAllServices() {
        boolean rtn = true;
        for (int i = 0; i <= 7; ++i) {
            rtn = this.ping(i) && rtn;
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingDDM() throws Exception {
        byte[] excsatReq = new byte[]{0, 117, -48, 1, 0, 0, 0, 111, 16, 65, 0, 11, 17, 71, 0, 7, 0, 9, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4, 20, -96, 0, 4};
        byte[] expectedRep = new byte[]{0, 113, -48, 3, 0, 0, 0, 107, 20, 67, 0, 7, 17, 71, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, -96, 0, 4, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4};
        OutputStream os = null;
        InputStream is = null;
        try {
            this.jpingThread_ = new JPingThread();
            this.jpingDaemon_ = new Thread((Runnable)this.jpingThread_, "AS400JPingDaemon");
            this.jpingDaemon_.setDaemon(true);
            this.jpingDaemon_.start();
            AS400JPing aS400JPing = this;
            synchronized (aS400JPing) {
                block30: {
                    try {
                        if (Trace.traceOn_) {
                            Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                        }
                        this.wait(this.time_);
                    }
                    catch (InterruptedException ie) {
                        if (!Trace.traceOn_) break block30;
                        Trace.log(2, "Unexpected exception.", (Throwable)ie);
                    }
                }
            }
            if (this.socketContainer_ == null) {
                this.jpingDaemon_.interrupt();
                throw new Exception("Ping Timeout occurred.");
            }
            os = this.socketContainer_.getOutputStream();
            if (Trace.traceOn_) {
                Trace.log(1, "Ping DDM: Writing data");
            }
            os.write(excsatReq);
            if (Trace.traceOn_) {
                Trace.log(1, "Ping DDM: flushing write");
            }
            os.flush();
            is = this.socketContainer_.getInputStream();
            byte[] excsatRep = new byte[113];
            if (Trace.traceOn_) {
                Trace.log(1, "Ping DDM: Reading data");
            }
            int numBytesRead = is.read(excsatRep);
            if (Trace.traceOn_) {
                Trace.log(1, "Ping DDM: " + numBytesRead + " bytes read");
            }
            if (numBytesRead < excsatRep.length) {
                Trace.log(2, "Unexpected DDM server response.", excsatRep);
                throw new Exception("Unexpected DDM server response.");
            }
            for (int i = 0; i < 113; ++i) {
                if (excsatRep[i] == expectedRep[i]) continue;
                Trace.log(2, "Unexpected DDM server response.", excsatRep);
                throw new Exception("Unexpected DDM server response.");
            }
        }
        catch (Exception e) {
            if (e.getMessage().equals("Ping Timeout occurred.")) {
                throw e;
            }
            if (e.getMessage().equals("Read timed out")) {
                throw e;
            }
            Exception newException = new Exception("Unexpected exception.", e);
            throw newException;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
        }
    }

    public void setPrintWriter(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.writer_ = new PrintWriter(stream, true);
    }

    public void setTimeout(long time) {
        this.time_ = time;
    }

    private class JPingThread
    implements Runnable {
        private JPingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (AS400JPing.this.service_ == 5) {
                    AS400JPing.this.socketContainer_ = PortMapper.getServerSocket(AS400JPing.this.systemName_, AS400JPing.this.service_, AS400JPing.this.useSSL_, AS400JPing.this.socketProperties_, true);
                } else {
                    AS400JPing.this.socketContainer_ = PortMapper.getServerSocket(AS400JPing.this.systemName_, AS400JPing.this.service_, AS400JPing.this.useSSL_, AS400JPing.this.socketProperties_, false);
                }
            }
            catch (Exception e) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Unexpected exception.", (Throwable)e);
                }
            }
            finally {
                AS400JPing aS400JPing = AS400JPing.this;
                synchronized (aS400JPing) {
                    AS400JPing.this.notifyAll();
                }
            }
        }
    }
}

