/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDLobLocator {
    private AS400JDBCConnection connection_;
    private boolean dataCompression_;
    private int id_;
    private int handle_ = -1;
    private long length_ = -1L;
    private int maxLength_;
    private int columnIndex_ = -1;
    private boolean graphic_;
    DBReplyRequestedDS retrieveDataReply = null;

    JDLobLocator(AS400JDBCConnection connection, int id, int maxLength, boolean graphic) {
        this.connection_ = connection;
        this.id_ = id;
        this.maxLength_ = maxLength;
        this.dataCompression_ = this.connection_.getDataCompression() == 1;
        this.graphic_ = graphic;
    }

    JDLobLocator(JDLobLocator loc) {
        this.connection_ = loc.connection_;
        this.id_ = loc.id_;
        this.maxLength_ = loc.maxLength_;
        this.dataCompression_ = loc.dataCompression_;
        this.graphic_ = loc.graphic_;
        this.handle_ = loc.handle_;
        this.length_ = loc.length_;
        this.columnIndex_ = loc.columnIndex_;
    }

    synchronized int getHandle() {
        return this.handle_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getLength() throws SQLException {
        if (this.length_ < 0L) {
            try {
                DBBaseRequestDS request = null;
                DBReplyRequestedDS getLengthReply = null;
                try {
                    request = DBDSPool.getDBSQLRequestDS(6166, this.id_, -2080374784, 0);
                    ((DBSQLRequestDS)request).setLOBLocatorHandle(this.handle_);
                    ((DBSQLRequestDS)request).setRequestedSize(0);
                    ((DBSQLRequestDS)request).setStartOffset(0);
                    ((DBSQLRequestDS)request).setCompressionIndicator(this.dataCompression_ ? 241 : 240);
                    ((DBSQLRequestDS)request).setReturnCurrentLengthIndicator(241);
                    if (this.columnIndex_ != -1) {
                        ((DBSQLRequestDS)request).setColumnIndex(this.columnIndex_);
                    }
                    getLengthReply = this.connection_.sendAndReceive(request, this.id_);
                    int errorClass = getLengthReply.getErrorClass();
                    int returnCode = getLengthReply.getReturnCode();
                    if (errorClass != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                    }
                    this.length_ = getLengthReply.getCurrentLOBLength();
                }
                finally {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (getLengthReply != null) {
                        getLengthReply.returnToPool();
                        getLengthReply = null;
                    }
                }
            }
            catch (DBDataStreamException e) {
                JDError.throwSQLException((Object)this, "HY000", e);
            }
        }
        return this.length_;
    }

    int getMaxLength() {
        return this.maxLength_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DBLobData retrieveData(long offset, int length) throws SQLException {
        DBLobData dBLobData;
        block14: {
            if (offset < 0L || length < 0) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if (offset >= (long)this.getMaxLength()) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if (offset > Integer.MAX_VALUE) {
                offset = Integer.MAX_VALUE;
            }
            DBSQLRequestDS request = null;
            try {
                request = DBDSPool.getDBSQLRequestDS(6166, this.id_, -2080374784, 0);
                request.setLOBLocatorHandle(this.handle_);
                request.setRequestedSize(length);
                request.setStartOffset((int)offset);
                request.setCompressionIndicator(this.dataCompression_ ? 241 : 240);
                request.setReturnCurrentLengthIndicator(241);
                if (this.columnIndex_ != -1) {
                    request.setColumnIndex(this.columnIndex_);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Retrieving lob data from handle: " + this.handle_ + " bytesToRead: " + length + " startingOffset: " + offset + " dataCompression: " + this.dataCompression_ + " columnIndex: " + this.columnIndex_);
                }
                if (this.retrieveDataReply != null) {
                    this.retrieveDataReply.returnToPool();
                    this.retrieveDataReply = null;
                }
                this.retrieveDataReply = this.connection_.sendAndReceive(request, this.id_);
                int errorClass = this.retrieveDataReply.getErrorClass();
                int returnCode = this.retrieveDataReply.getReturnCode();
                if (errorClass != 0) {
                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                }
                this.length_ = this.retrieveDataReply.getCurrentLOBLength();
                DBLobData lobData = this.retrieveDataReply.getLOBData();
                if (this.graphic_) {
                    lobData.adjustForGraphic();
                }
                dBLobData = lobData;
                if (request == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    throw throwable;
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException((Object)this, "HY000", e);
                    return null;
                }
            }
            request.returnToPool();
            request = null;
        }
        return dBLobData;
    }

    void setColumnIndex(int columnIndex) {
        this.columnIndex_ = columnIndex;
    }

    synchronized void setHandle(int handle) {
        this.handle_ = handle;
        this.length_ = -1L;
    }

    int writeData(long offset, byte data, boolean truncate) throws SQLException {
        return this.writeData(offset, new byte[]{data}, 0, 1, truncate);
    }

    int writeData(long offset, byte[] data, boolean truncate) throws SQLException {
        return this.writeData(offset, data, 0, data.length, truncate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int writeData(long lobOffset, byte[] data, int offset, int length, boolean truncate) throws SQLException {
        int n;
        DBReplyRequestedDS writeDataReply;
        block13: {
            if (data == null) {
                throw new NullPointerException("data");
            }
            if (lobOffset < 0L || length < 0) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if (lobOffset > Integer.MAX_VALUE) {
                lobOffset = Integer.MAX_VALUE;
            }
            int lengthToUse = this.graphic_ ? length / 2 : length;
            DBSQLRequestDS request = null;
            writeDataReply = null;
            try {
                request = DBDSPool.getDBSQLRequestDS(6167, this.id_, -2080374784, 0);
                request.setLobTruncation(truncate);
                request.setLOBLocatorHandle(this.handle_);
                request.setRequestedSize(lengthToUse);
                request.setStartOffset((int)lobOffset);
                request.setCompressionIndicator(240);
                request.setLOBData(data, offset, length);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Writing lob data to handle: " + this.handle_ + " offset: " + lobOffset + " length: " + length);
                }
                writeDataReply = this.connection_.sendAndReceive(request, this.id_);
                int errorClass = writeDataReply.getErrorClass();
                int returnCode = writeDataReply.getReturnCode();
                if (errorClass != 0) {
                    JDError.throwSQLException(this, this.connection_, this.id_, errorClass, returnCode);
                }
                this.length_ = -1L;
                n = length;
                if (request == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (request != null) {
                        request.returnToPool();
                        request = null;
                    }
                    if (writeDataReply != null) {
                        writeDataReply.returnToPool();
                        writeDataReply = null;
                    }
                    throw throwable;
                }
                catch (DBDataStreamException e) {
                    JDError.throwSQLException((Object)this, "HY000", e);
                    return -1;
                }
            }
            request.returnToPool();
            request = null;
        }
        if (writeDataReply != null) {
            writeDataReply.returnToPool();
            writeDataReply = null;
        }
        return n;
    }

    boolean isGraphic() {
        return this.graphic_;
    }

    void setGraphic(boolean isGraphic) {
        this.graphic_ = isGraphic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void free() throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm610) {
            JDError.throwSQLException((Object)this, "IM001");
            return;
        }
        DBBaseRequestDS request = null;
        DBReplyRequestedDS freeReply = null;
        try {
            request = DBDSPool.getDBSQLRequestDS(6169, this.id_, Integer.MIN_VALUE, 0);
            ((DBSQLRequestDS)request).setLOBLocatorHandle(this.handle_);
            freeReply = this.connection_.sendAndReceive(request, this.id_);
            if (this.retrieveDataReply != null) {
                this.retrieveDataReply.returnToPool();
                this.retrieveDataReply = null;
            }
        }
        catch (DBDataStreamException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
        }
        finally {
            if (request != null) {
                request.returnToPool();
                request = null;
            }
            if (freeReply != null) {
                freeReply.returnToPool();
                freeReply = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.retrieveDataReply != null) {
            this.retrieveDataReply.returnToPool();
            this.retrieveDataReply = null;
        }
    }
}

