/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ObsoleteApi;
import com.google.api.gax.httpjson.AutoValue_HttpJsonCallOptions;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.protobuf.TypeRegistry;
import java.time.Instant;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@AutoValue
public abstract class HttpJsonCallOptions {
    public static final HttpJsonCallOptions DEFAULT = HttpJsonCallOptions.newBuilder().build();

    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public final Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getTimeoutDuration());
    }

    @Nullable
    public abstract java.time.Duration getTimeoutDuration();

    @Nullable
    @ObsoleteApi(value="Use getDeadlineInstant() instead")
    public final org.threeten.bp.Instant getDeadline() {
        return TimeConversionUtils.toThreetenInstant((Instant)this.getDeadlineInstant());
    }

    @Nullable
    public abstract Instant getDeadlineInstant();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TypeRegistry getTypeRegistry();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_HttpJsonCallOptions.Builder();
    }

    public HttpJsonCallOptions merge(HttpJsonCallOptions inputOptions) {
        TypeRegistry newTypeRegistry;
        Credentials newCredentials;
        java.time.Duration newTimeout;
        if (inputOptions == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        Instant newDeadline = inputOptions.getDeadlineInstant();
        if (newDeadline != null) {
            builder.setDeadlineInstant(newDeadline);
        }
        if (inputOptions.getTimeout() != null && (newTimeout = inputOptions.getTimeoutDuration()) != null) {
            builder.setTimeoutDuration(newTimeout);
        }
        if ((newCredentials = inputOptions.getCredentials()) != null) {
            builder.setCredentials(newCredentials);
        }
        if ((newTypeRegistry = inputOptions.getTypeRegistry()) != null) {
            builder.setTypeRegistry(newTypeRegistry);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @ObsoleteApi(value="Use setTimeoutDuration(java.time.Duration) instead")
        public final Builder setTimeout(Duration value) {
            return this.setTimeoutDuration(TimeConversionUtils.toJavaTimeDuration((Duration)value));
        }

        public abstract Builder setTimeoutDuration(java.time.Duration var1);

        @ObsoleteApi(value="Use setDeadlineInstant(java.time.Instant) instead")
        public final Builder setDeadline(org.threeten.bp.Instant value) {
            return this.setDeadlineInstant(TimeConversionUtils.toJavaTimeInstant((org.threeten.bp.Instant)value));
        }

        public abstract Builder setDeadlineInstant(Instant var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTypeRegistry(TypeRegistry var1);

        public abstract HttpJsonCallOptions build();
    }
}

