/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.schemas.utils;

import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class AvroJodaTimeConversions {

    public static class LossyTimestampMicrosConversion
    extends TimestampMicrosConversion {
        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized DateTime timestamp, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return 1000L * timestamp.getMillis();
        }
    }

    public static class TimestampMicrosConversion
    extends Conversion<DateTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized DateTime> getConvertedType() {
            return DateTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "timestamp-micros";
        }

        public @UnknownKeyFor @NonNull @Initialized DateTime fromLong(@UnknownKeyFor @NonNull @Initialized Long microsFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return new DateTime(microsFromEpoch / 1000L, DateTimeZone.UTC);
        }
    }

    public static class TimestampConversion
    extends Conversion<DateTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized DateTime> getConvertedType() {
            return DateTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "timestamp-millis";
        }

        public @UnknownKeyFor @NonNull @Initialized DateTime fromLong(@UnknownKeyFor @NonNull @Initialized Long millisFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return new DateTime((Object)millisFromEpoch, DateTimeZone.UTC);
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized DateTime timestamp, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return timestamp.getMillis();
        }
    }

    public static class LossyTimeMicrosConversion
    extends TimeMicrosConversion {
        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized LocalTime time, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return 1000L * (long)time.millisOfDay().get();
        }
    }

    public static class TimeMicrosConversion
    extends Conversion<LocalTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "time-micros";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalTime fromLong(@UnknownKeyFor @NonNull @Initialized Long microsFromMidnight, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return LocalTime.fromMillisOfDay((long)(microsFromMidnight / 1000L));
        }
    }

    public static class TimeConversion
    extends Conversion<LocalTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "time-millis";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalTime fromInt(@UnknownKeyFor @NonNull @Initialized Integer millisFromMidnight, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return LocalTime.fromMillisOfDay((long)millisFromMidnight.intValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Integer toInt(@UnknownKeyFor @NonNull @Initialized LocalTime time, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return time.millisOfDay().get();
        }
    }

    public static class DateConversion
    extends Conversion<LocalDate> {
        private static final @UnknownKeyFor @NonNull @Initialized LocalDate EPOCH_DATE = new LocalDate(1970, 1, 1);

        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalDate> getConvertedType() {
            return LocalDate.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "date";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalDate fromInt(@UnknownKeyFor @NonNull @Initialized Integer daysFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return EPOCH_DATE.plusDays(daysFromEpoch.intValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Integer toInt(@UnknownKeyFor @NonNull @Initialized LocalDate date, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return Days.daysBetween((ReadablePartial)EPOCH_DATE, (ReadablePartial)date).getDays();
        }
    }
}

