/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.abort;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.abort.Abort;
import org.apache.hop.pipeline.transforms.abort.AbortData;
import org.w3c.dom.Node;

@Transform(id="Abort", name="i18n::Abort.Name", description="i18n::Abort.Description", image="abort.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::AbortMeta.keyword"}, documentationUrl="/pipeline/transforms/abort.html")
public class AbortMeta
extends BaseTransformMeta<Abort, AbortData> {
    private static final Class<?> PKG = AbortMeta.class;
    @HopMetadataProperty(key="row_threshold", injectionKeyDescription="AbortDialog.Options.RowThreshold.Label")
    private String rowThreshold;
    @HopMetadataProperty(injectionKeyDescription="AbortDialog.Logging.AbortMessage.Tooltip")
    private String message;
    @HopMetadataProperty(key="always_log_rows", injectionKeyDescription="AbortDialog.Logging.AlwaysLogRows.Label")
    private boolean alwaysLogRows;
    @HopMetadataProperty(key="abort_option", injectionKeyDescription="AbortMeta.Injection.AbortOption")
    private AbortOption abortOption = AbortOption.ABORT;

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length == 0) {
            CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"AbortMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public void setDefault() {
        this.rowThreshold = "0";
        this.message = "";
        this.alwaysLogRows = true;
        this.abortOption = AbortOption.ABORT_WITH_ERROR;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        if (this.abortOption == null) {
            String awe = XmlHandler.getTagValue((Node)transformNode, (String)"abort_with_error");
            if (awe == null) {
                awe = "Y";
            }
            this.abortOption = "Y".equalsIgnoreCase(awe) ? AbortOption.ABORT_WITH_ERROR : AbortOption.ABORT;
        }
    }

    public boolean isAbortWithError() {
        return this.abortOption == AbortOption.ABORT_WITH_ERROR;
    }

    public boolean isAbort() {
        return this.abortOption == AbortOption.ABORT;
    }

    public boolean isSafeStop() {
        return this.abortOption == AbortOption.SAFE_STOP;
    }

    public String getRowThreshold() {
        return this.rowThreshold;
    }

    public void setRowThreshold(String rowThreshold) {
        this.rowThreshold = rowThreshold;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isAlwaysLogRows() {
        return this.alwaysLogRows;
    }

    public void setAlwaysLogRows(boolean alwaysLogRows) {
        this.alwaysLogRows = alwaysLogRows;
    }

    public AbortOption getAbortOption() {
        return this.abortOption;
    }

    public void setAbortOption(AbortOption abortOption) {
        this.abortOption = abortOption;
    }

    public boolean supportsMultiCopyExecution() {
        return false;
    }

    public static enum AbortOption {
        ABORT,
        ABORT_WITH_ERROR,
        SAFE_STOP;

    }
}

