/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.truststore.CustomSocketFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapSslProtocol;

public class LdapTlsProtocol
extends LdapSslProtocol {
    private StartTlsResponse startTlsResponse;

    public LdapTlsProtocol(ILogChannel log, IVariables variables, ILdapMeta meta, Collection<String> binaryAttributes) {
        super(log, variables, meta, binaryAttributes);
    }

    @Override
    protected String getConnectionPrefix() {
        return "ldap://";
    }

    public static String getName() {
        return "LDAP TLS";
    }

    @Override
    protected void doConnect(String username, String password) throws HopException {
        super.doConnect(username, password);
        StartTlsRequest tlsRequest = new StartTlsRequest();
        try {
            this.startTlsResponse = (StartTlsResponse)this.getCtx().extendedOperation(tlsRequest);
            this.startTlsResponse.negotiate((SSLSocketFactory)CustomSocketFactory.getDefault());
        }
        catch (NamingException e) {
            throw new HopException((Throwable)e);
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
    }

    @Override
    protected void configureSslEnvironment(Map<String, String> env) {
    }

    @Override
    public void close() throws HopException {
        if (this.startTlsResponse != null) {
            try {
                this.startTlsResponse.close();
            }
            catch (IOException e) {
                throw new HopException((Throwable)e);
            }
            finally {
                this.startTlsResponse = null;
            }
        }
        super.close();
    }
}

