/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryMultimapSideInputView<@UnknownKeyFor K, @UnknownKeyFor V>
implements Materializations.MultimapView<K, V> {
    private static final  @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView EMPTY = new Materializations.MultimapView(){

        public @UnknownKeyFor @NonNull @Initialized Iterable get() {
            return Collections.emptyList();
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable get(@Nullable @UnknownKeyFor @Initialized Object k) {
            return Collections.emptyList();
        }
    };
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized List<V>>> structuralKeyToValuesMap;

    public static <K, V>  @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> fromIterable(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<K, V>> values) {
        HashMap<Object, KV<Object, List<KV>>> data = new HashMap<Object, KV<Object, List<KV>>>();
        for (KV value : values) {
            KV keyedValues = data.computeIfAbsent(keyCoder.structuralValue(value.getKey()), o -> KV.of(value.getKey(), new ArrayList()));
            ((List)keyedValues.getValue()).add(value.getValue());
        }
        return new InMemoryMultimapSideInputView<K, V>(keyCoder, data);
    }

    public static <K, V>  @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> empty() {
        return EMPTY;
    }

    private InMemoryMultimapSideInputView(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized List<V>>> data) {
        this.keyCoder = keyCoder;
        this.structuralKeyToValuesMap = data;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterable<K> get() {
        return Iterables.unmodifiableIterable((Iterable)FluentIterable.from(this.structuralKeyToValuesMap.values()).transform(kListKV -> kListKV.getKey()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K k) {
        KV<K, List<V>> records = this.structuralKeyToValuesMap.get(this.keyCoder.structuralValue(k));
        if (records == null) {
            return Collections.emptyList();
        }
        return records.getValue();
    }
}

