/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Objects;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

final class PCollectionViewWindow<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<T> view;
    private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

    private PCollectionViewWindow(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        this.view = view;
        this.window = window;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionViewWindow<T> of(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return new PCollectionViewWindow<T>(view, window);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionView<T> getView() {
        return this.view;
    }

    public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
        return this.window;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object otherObject) {
        if (!(otherObject instanceof PCollectionViewWindow)) {
            return false;
        }
        PCollectionViewWindow other = (PCollectionViewWindow)otherObject;
        return this.getView().equals(other.getView()) && this.getWindow().equals(other.getWindow());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getView(), this.getWindow());
    }
}

