/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import java.io.IOException;
import org.apache.beam.sdk.metrics.MetricResults;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public interface PipelineResult {
    public @UnknownKeyFor @NonNull @Initialized State getState();

    public @UnknownKeyFor @NonNull @Initialized State cancel() throws @UnknownKeyFor @NonNull @Initialized IOException;

    public @UnknownKeyFor @NonNull @Initialized State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration var1);

    public @UnknownKeyFor @NonNull @Initialized State waitUntilFinish();

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics();

    public static enum State {
        UNKNOWN(false, false),
        STOPPED(false, false),
        RUNNING(false, false),
        DONE(true, false),
        FAILED(true, false),
        CANCELLED(true, false),
        UPDATED(true, true),
        UNRECOGNIZED(false, false);

        private final @UnknownKeyFor @NonNull @Initialized boolean terminal;
        private final @UnknownKeyFor @NonNull @Initialized boolean hasReplacement;

        private State(boolean terminal, boolean hasReplacement) {
            this.terminal = terminal;
            this.hasReplacement = hasReplacement;
        }

        public final @UnknownKeyFor @NonNull @Initialized boolean isTerminal() {
            return this.terminal;
        }

        public final @UnknownKeyFor @NonNull @Initialized boolean hasReplacementJob() {
            return this.hasReplacement;
        }
    }
}

