/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigEndianShortCoder
extends AtomicCoder<Short> {
    private static final @UnknownKeyFor @NonNull @Initialized BigEndianShortCoder INSTANCE = new BigEndianShortCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Short> TYPE_DESCRIPTOR = new TypeDescriptor<Short>(){};

    public static @UnknownKeyFor @NonNull @Initialized BigEndianShortCoder of() {
        return INSTANCE;
    }

    private BigEndianShortCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Short value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Short");
        }
        BitConverters.writeBigEndianShort(value, outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Short decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            return BitConverters.readBigEndianShort(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Short value) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Short> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Short value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Short");
        }
        return 2L;
    }
}

