/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.Serializable;
import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public abstract class WindowFn<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements Serializable,
HasDisplayData {
    public abstract @UnknownKeyFor @NonNull @Initialized Collection<W> assignWindows(@UnknownKeyFor @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public abstract void mergeWindows(@UnknownKeyFor @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized MergeContext var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is not compatible with %s", this.getClass().getSimpleName(), other.getClass().getSimpleName()));
        }
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder();

    public abstract @UnknownKeyFor @NonNull @Initialized WindowMappingFn<W> getDefaultWindowMappingFn();

    public @UnknownKeyFor @NonNull @Initialized boolean isNonMerging() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean assignsToOneWindow() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<W> getWindowTypeDescriptor() {
        return new TypeDescriptor<W>(this){};
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
    }

    public abstract class MergeContext {
        public abstract @UnknownKeyFor @NonNull @Initialized Collection<W> windows();

        public abstract void merge(@UnknownKeyFor @NonNull @Initialized Collection<W> var1, W var2) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }

    public abstract class AssignContext {
        public abstract T element();

        public abstract @UnknownKeyFor @NonNull @Initialized Instant timestamp();

        public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow window();
    }
}

