/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimaps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.ClassPath;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.Invokable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.Parameter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.TypeToken;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ApiSurface {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ApiSurface.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> rootClasses;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Pattern> patternsToPrune;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> exposedToExposers = null;
    private @UnknownKeyFor @NonNull @Initialized Pattern prunedPattern = null;
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Type> visited = null;

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> classesInPackage(@UnknownKeyFor @NonNull @Initialized String packageName) {
        return new Matchers.ClassInPackage(packageName);
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized ApiSurface> containsOnlyClassesMatching(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> classMatchers) {
        return new Matchers.ClassesInSurfaceMatcher(classMatchers);
    }

    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized ApiSurface> containsOnlyClassesMatching(Matcher<Class<?>> ... classMatchers) {
        return new Matchers.ClassesInSurfaceMatcher(Sets.newHashSet((Object[])classMatchers));
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized ApiSurface> containsOnlyPackages(String ... packageNames) {
        return ApiSurface.containsOnlyPackages(Sets.newHashSet((Object[])packageNames));
    }

    public static @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized ApiSurface> containsOnlyPackages(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> packageNames) {
        Function packageNameToClassMatcher = ApiSurface::classesInPackage;
        ImmutableSet classesInPackages = FluentIterable.from(packageNames).transform(packageNameToClassMatcher).toSet();
        return ApiSurface.containsOnlyClassesMatching(classesInPackages);
    }

    public static @UnknownKeyFor @NonNull @Initialized ApiSurface empty() {
        LOG.debug("Returning an empty ApiSurface");
        return new ApiSurface(Collections.emptySet(), Collections.emptySet());
    }

    public static @UnknownKeyFor @NonNull @Initialized ApiSurface ofPackage(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ApiSurface.empty().includingPackage(packageName, classLoader);
    }

    public static @UnknownKeyFor @NonNull @Initialized ApiSurface ofPackage(@UnknownKeyFor @NonNull @Initialized Package aPackage, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ApiSurface.ofPackage(aPackage.getName(), classLoader);
    }

    public static @UnknownKeyFor @NonNull @Initialized ApiSurface ofClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return ApiSurface.empty().includingClass(clazz);
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface includingPackage(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
        HashSet newRootClasses = Sets.newHashSet();
        for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive(packageName)) {
            Class clazz = null;
            try {
                clazz = classInfo.load();
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("Failed to load class: {}", (Object)classInfo.toString(), (Object)e);
                continue;
            }
            if (!this.exposed(clazz.getModifiers())) continue;
            newRootClasses.add(clazz);
        }
        LOG.debug("Including package {} and subpackages: {}", (Object)packageName, (Object)newRootClasses);
        newRootClasses.addAll(this.rootClasses);
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface includingClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        HashSet newRootClasses = Sets.newHashSet();
        LOG.debug("Including class {}", clazz);
        newRootClasses.add(clazz);
        newRootClasses.addAll(this.rootClasses);
        return new ApiSurface(newRootClasses, this.patternsToPrune);
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface pruningPrefix(@UnknownKeyFor @NonNull @Initialized String prefix) {
        return this.pruningPattern(Pattern.compile(Pattern.quote(prefix) + ".*"));
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface pruningClassName(@UnknownKeyFor @NonNull @Initialized String className) {
        return this.pruningPattern(Pattern.compile(Pattern.quote(className)));
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface pruningClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return this.pruningClassName(clazz.getName());
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface pruningPattern(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        HashSet newPatterns = Sets.newHashSet();
        newPatterns.addAll(this.patternsToPrune);
        newPatterns.add(pattern);
        return new ApiSurface(this.rootClasses, newPatterns);
    }

    public @UnknownKeyFor @NonNull @Initialized ApiSurface pruningPattern(@UnknownKeyFor @NonNull @Initialized String patternString) {
        return this.pruningPattern(Pattern.compile(patternString));
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getRootClasses() {
        return this.rootClasses;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getExposedClasses() {
        return this.getExposedToExposers().keySet();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getAnyExposurePath(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> exposedClass) {
        HashSet excluded = Sets.newHashSet();
        excluded.add(exposedClass);
        List<Class<?>> path = this.getAnyExposurePath(exposedClass, excluded);
        if (path == null) {
            throw new IllegalArgumentException("Class " + exposedClass + " has no path back to any root class. It should never have been considered exposed.");
        }
        return path;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getAnyExposurePath(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> exposedClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> excluded) {
        ArrayList exposurePath = Lists.newArrayList();
        exposurePath.add(exposedClass);
        Collection exposers = this.getExposedToExposers().get(exposedClass);
        if (exposers.isEmpty()) {
            throw new IllegalArgumentException("Class " + exposedClass + " is not exposed.");
        }
        for (Class exposer : exposers) {
            if (excluded.contains(exposer)) continue;
            if (exposer == null) {
                return exposurePath;
            }
            List<Class<?>> restOfPath = this.getAnyExposurePath(exposer, (Set<Class<?>>)Sets.union(excluded, (Set)Sets.newHashSet((Object[])new Class[]{exposer})));
            if (restOfPath == null) continue;
            exposurePath.addAll(restOfPath);
            return exposurePath;
        }
        return null;
    }

    private ApiSurface(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> rootClasses, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Pattern> patternsToPrune) {
        this.rootClasses = rootClasses;
        this.patternsToPrune = patternsToPrune;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getExposedToExposers() {
        if (this.exposedToExposers == null) {
            this.constructExposedToExposers();
        }
        return this.exposedToExposers;
    }

    private void constructExposedToExposers() {
        this.visited = Sets.newHashSet();
        this.exposedToExposers = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);
        for (Class<?> clazz : this.rootClasses) {
            this.addExposedTypes(clazz, null);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Pattern getPrunedPattern() {
        if (this.prunedPattern == null) {
            this.constructPrunedPattern();
        }
        return this.prunedPattern;
    }

    private void constructPrunedPattern() {
        HashSet prunedPatternStrings = Sets.newHashSet();
        for (Pattern patternToPrune : this.patternsToPrune) {
            prunedPatternStrings.add(patternToPrune.pattern());
        }
        this.prunedPattern = Pattern.compile("(" + Joiner.on((String)")|(").join((Iterable)prunedPatternStrings) + ")");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean pruned(@UnknownKeyFor @NonNull @Initialized Type type) {
        return this.pruned(TypeToken.of((Type)type).getRawType());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean pruned(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return clazz.isPrimitive() || clazz.isArray() || clazz.getCanonicalName().equals("jdk.internal.HotSpotIntrinsicCandidate") || this.getPrunedPattern().matcher(clazz.getName()).matches();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean done(@UnknownKeyFor @NonNull @Initialized Type type) {
        return this.visited.contains(type);
    }

    private void recordExposure(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> exposed, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        this.exposedToExposers.put(exposed, cause);
    }

    private void recordExposure(@UnknownKeyFor @NonNull @Initialized Type exposed, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        this.exposedToExposers.put((Object)TypeToken.of((Type)exposed).getRawType(), cause);
    }

    private void visit(@UnknownKeyFor @NonNull @Initialized Type type) {
        this.visited.add(type);
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized TypeToken type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        LOG.debug("Adding exposed types from {}, which is the type in type token {}", (Object)type.getType(), (Object)type);
        this.addExposedTypes(type.getType(), cause);
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized Type type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        if (type instanceof TypeVariable) {
            LOG.debug("Adding exposed types from {}, which is a type variable", (Object)type);
            this.addExposedTypes((TypeVariable)type, cause);
        } else if (type instanceof WildcardType) {
            LOG.debug("Adding exposed types from {}, which is a wildcard type", (Object)type);
            this.addExposedTypes((WildcardType)type, cause);
        } else if (type instanceof GenericArrayType) {
            LOG.debug("Adding exposed types from {}, which is a generic array type", (Object)type);
            this.addExposedTypes((GenericArrayType)type, cause);
        } else if (type instanceof ParameterizedType) {
            LOG.debug("Adding exposed types from {}, which is a parameterized type", (Object)type);
            this.addExposedTypes((ParameterizedType)type, cause);
        } else if (type instanceof Class) {
            LOG.debug("Adding exposed types from {}, which is a class", (Object)type);
            this.addExposedTypes((Class)type, cause);
        } else {
            throw new IllegalArgumentException("Unknown implementation of Type");
        }
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized TypeVariable type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        for (Type bound : type.getBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type bound on {}", (Object)bound, (Object)type);
            this.addExposedTypes(bound, cause);
        }
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized WildcardType type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        this.visit(type);
        for (Type lowerBound : type.getLowerBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type lower bound on wildcard type {}", (Object)lowerBound, (Object)type);
            this.addExposedTypes(lowerBound, cause);
        }
        for (Type upperBound : type.getUpperBounds()) {
            LOG.debug("Adding exposed types from {}, which is a type upper bound on wildcard type {}", (Object)upperBound, (Object)type);
            this.addExposedTypes(upperBound, cause);
        }
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized GenericArrayType type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        if (this.done(type)) {
            return;
        }
        this.visit(type);
        LOG.debug("Adding exposed types from {}, which is the component type on generic array type {}", (Object)type.getGenericComponentType(), (Object)type);
        this.addExposedTypes(type.getGenericComponentType(), cause);
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized ParameterizedType type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        boolean alreadyDone = this.done(type);
        if (!this.pruned(type)) {
            this.visit(type);
            this.recordExposure(type, cause);
        }
        if (alreadyDone) {
            return;
        }
        LOG.debug("Adding exposed types from {}, which is the raw type on parameterized type {}", (Object)type.getRawType(), (Object)type);
        this.addExposedTypes(type.getRawType(), cause);
        for (Type typeArg : type.getActualTypeArguments()) {
            LOG.debug("Adding exposed types from {}, which is a type argument on parameterized type {}", (Object)typeArg, (Object)type);
            this.addExposedTypes(typeArg, cause);
        }
    }

    private void addExposedTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        if (this.pruned(clazz)) {
            return;
        }
        boolean alreadyDone = this.done(clazz);
        this.visit(clazz);
        this.recordExposure(clazz, cause);
        if (alreadyDone || this.pruned(clazz)) {
            return;
        }
        TypeToken token = TypeToken.of(clazz);
        for (TypeToken superType : token.getTypes()) {
            if (superType.equals((Object)token)) continue;
            LOG.debug("Adding exposed types from {}, which is a super type token on {}", (Object)superType, clazz);
            this.addExposedTypes(superType, clazz);
        }
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!this.exposed(clazz2.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an exposed inner class of {}", clazz2, clazz);
            this.addExposedTypes(clazz2, clazz);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            if (!this.exposed(((Field)annotatedElement).getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an exposed field on {}", (Object)annotatedElement, clazz);
            this.addExposedTypes((Field)annotatedElement, clazz);
        }
        for (Invokable invokable : this.getExposedInvokables(token)) {
            LOG.debug("Adding exposed types from {}, which is an exposed invokable on {}", (Object)invokable, clazz);
            this.addExposedTypes(invokable, clazz);
        }
    }

    private void addExposedTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Invokable<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> invokable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        this.addExposedTypes(invokable.getReturnType(), cause);
        for (Annotation annotation : invokable.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!Modifier.isPublic(annotationClass.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an annotation on invokable {}", (Object)annotation, invokable);
            this.addExposedTypes(annotationClass, cause);
        }
        for (Parameter parameter : invokable.getParameters()) {
            LOG.debug("Adding exposed types from {}, which is a parameter on invokable {}", (Object)parameter, invokable);
            this.addExposedTypes(parameter, cause);
        }
        for (TypeToken exceptionType : invokable.getExceptionTypes()) {
            LOG.debug("Adding exposed types from {}, which is an exception type on invokable {}", (Object)exceptionType, invokable);
            this.addExposedTypes(exceptionType, cause);
        }
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized Parameter parameter, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        LOG.debug("Adding exposed types from {}, which is the type of parameter {}", (Object)parameter.getType(), (Object)parameter);
        this.addExposedTypes(parameter.getType(), cause);
        for (Annotation annotation : parameter.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!Modifier.isPublic(annotationClass.getModifiers())) continue;
            LOG.debug("Adding exposed types from {}, which is an annotation on parameter {}", (Object)annotation, (Object)parameter);
            this.addExposedTypes(annotationClass, cause);
        }
    }

    private void addExposedTypes(@UnknownKeyFor @NonNull @Initialized Field field, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cause) {
        this.addExposedTypes(field.getGenericType(), cause);
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            LOG.debug("Adding exposed types from {}, which is an annotation on field {}", (Object)annotation, (Object)field);
            this.addExposedTypes(annotation.annotationType(), cause);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Invokable> getExposedInvokables(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeToken<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        HashSet invokables = Sets.newHashSet();
        for (Constructor<?> constructor : type.getRawType().getConstructors()) {
            if (0 == (constructor.getModifiers() & 5)) continue;
            invokables.add(type.constructor(constructor));
        }
        for (Executable executable : type.getRawType().getMethods()) {
            if (0 == (((Method)executable).getModifiers() & 5)) continue;
            invokables.add(type.method((Method)executable));
        }
        return invokables;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean exposed(@UnknownKeyFor @NonNull @Initialized int modifiers) {
        return 0 != (modifiers & 5);
    }

    private static class Matchers {
        private Matchers() {
        }

        private static class ClassesInSurfaceMatcher
        extends TypeSafeDiagnosingMatcher<ApiSurface> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> classMatchers;

            private ClassesInSurfaceMatcher(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> classMatchers) {
                this.classMatchers = classMatchers;
            }

            private @UnknownKeyFor @NonNull @Initialized boolean verifyNoAbandoned(@UnknownKeyFor @NonNull @Initialized ApiSurface checkedApiSurface, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> allowedClasses, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
                Function toMessage = abandonedClassMatcher -> {
                    StringDescription description = new StringDescription();
                    description.appendText("No ");
                    abandonedClassMatcher.describeTo((Description)description);
                    return description.toString();
                };
                Predicate matchedByExposedClasses = classMatcher -> FluentIterable.from(checkedApiSurface.getExposedClasses()).anyMatch(arg_0 -> ((Matcher)classMatcher).matches(arg_0));
                ImmutableSet matchedClassMatchers = FluentIterable.from(allowedClasses).filter(matchedByExposedClasses).toSet();
                Sets.SetView abandonedClassMatchers = Sets.difference(allowedClasses, (Set)matchedClassMatchers);
                ImmutableList messages = FluentIterable.from((Iterable)abandonedClassMatchers).transform(toMessage).toSortedList((Comparator)Ordering.natural());
                if (!messages.isEmpty()) {
                    mismatchDescription.appendText("The following allowed scopes did not have matching classes on the API surface:\n\t" + Joiner.on((String)"\n\t").join((Iterable)messages));
                }
                return messages.isEmpty();
            }

            private @UnknownKeyFor @NonNull @Initialized boolean verifyNoDisallowed(@UnknownKeyFor @NonNull @Initialized ApiSurface checkedApiSurface, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> allowedClasses, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
                Function toExposure = checkedApiSurface::getAnyExposurePath;
                Maps.EntryTransformer toMessage = (aClass, exposure) -> aClass + " exposed via:\n\t\t" + Joiner.on((String)"\n\t\t").join((Iterable)exposure);
                Predicate disallowed = aClass -> !this.classIsAllowed((Class<?>)aClass, allowedClasses);
                FluentIterable disallowedClasses = FluentIterable.from(checkedApiSurface.getExposedClasses()).filter(disallowed);
                ImmutableMap exposures = Maps.toMap((Iterable)disallowedClasses, (Function)toExposure);
                ImmutableList messages = FluentIterable.from(Maps.transformEntries((Map)exposures, (Maps.EntryTransformer)toMessage).values()).toSortedList((Comparator)Ordering.natural());
                if (!messages.isEmpty()) {
                    mismatchDescription.appendText("The following disallowed classes appeared on the API surface:\n\t" + Joiner.on((String)"\n\t").join((Iterable)messages));
                }
                return messages.isEmpty();
            }

            private @UnknownKeyFor @NonNull @Initialized boolean classIsAllowed(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> allowedClasses) {
                return org.hamcrest.Matchers.anyOf(allowedClasses).matches(clazz);
            }

            protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(@UnknownKeyFor @NonNull @Initialized ApiSurface apiSurface, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
                boolean noDisallowed = this.verifyNoDisallowed(apiSurface, this.classMatchers, mismatchDescription);
                boolean noAbandoned = this.verifyNoAbandoned(apiSurface, this.classMatchers, mismatchDescription);
                return noDisallowed && noAbandoned;
            }

            public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
                description.appendText("API surface to include only:\n\t");
                for (Matcher<Class<?>> classMatcher : this.classMatchers) {
                    classMatcher.describeTo(description);
                    description.appendText("\n\t");
                }
            }
        }

        private static class ClassInPackage
        extends TypeSafeDiagnosingMatcher<Class<?>> {
            private final @UnknownKeyFor @NonNull @Initialized String packageName;

            private ClassInPackage(@UnknownKeyFor @NonNull @Initialized String packageName) {
                this.packageName = packageName;
            }

            public void describeTo(@UnknownKeyFor @NonNull @Initialized Description description) {
                description.appendText("Classes in package \"");
                description.appendText(this.packageName);
                description.appendText("\"");
            }

            protected @UnknownKeyFor @NonNull @Initialized boolean matchesSafely(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized Description mismatchDescription) {
                return clazz.getName().startsWith(this.packageName + ".");
            }
        }
    }
}

