/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.internal.TopicStatsClientSettings;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.AutoValue_TopicBacklogReaderSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.LimitingTopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReaderImpl;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Ticker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class TopicBacklogReaderSettings
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -4001752066450248673L;

    TopicBacklogReaderSettings() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized TopicPath topicPath();

    abstract @UnknownKeyFor @NonNull @Initialized Partition partition();

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_TopicBacklogReaderSettings.Builder();
    }

    private @UnknownKeyFor @NonNull @Initialized TopicStatsClient newClient() {
        return TopicStatsClient.create((TopicStatsClientSettings)TopicStatsClientSettings.newBuilder().setRegion(this.topicPath().location().extractRegion()).build());
    }

    @UnknownKeyFor @NonNull @Initialized TopicBacklogReader instantiate() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        TopicBacklogReaderImpl impl = new TopicBacklogReaderImpl(this.newClient(), this.topicPath(), this.partition());
        return new LimitingTopicBacklogReader(impl, Ticker.systemTicker());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTopicPath(@UnknownKeyFor @NonNull @Initialized TopicPath var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPartition(@UnknownKeyFor @NonNull @Initialized Partition var1);

        abstract @UnknownKeyFor @NonNull @Initialized TopicBacklogReaderSettings build();
    }
}

