/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandraoutput;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutput;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutputData;

@Transform(id="CassandraOutput", image="cassandraout.svg", name="Cassandra output", description="Writes to a Cassandra table", documentationUrl="/pipeline/transforms/cassandra-output.html", keywords={"i18n::CassandraOutputMeta.keyword"}, categoryDescription="Cassandra")
public class CassandraOutputMeta
extends BaseTransformMeta<CassandraOutput, CassandraOutputData> {
    public static final Class<?> PKG = CassandraOutputMeta.class;
    @HopMetadataProperty(key="connection", injectionKey="CONNECTION", injectionKeyDescription="CassandraOutput.Injection.CONNECTION")
    protected String connectionName;
    @HopMetadataProperty(key="schema_host", injectionKey="SCHEMA_HOST", injectionKeyDescription="CassandraOutput.Injection.SCHEMA_HOST")
    protected String schemaHost;
    @HopMetadataProperty(key="schema_port", injectionKey="SCHEMA_PORT", injectionKeyDescription="CassandraOutput.Injection.SCHEMA_PORT")
    protected String schemaPort;
    @HopMetadataProperty(key="table", injectionKey="TABLE", injectionKeyDescription="CassandraOutput.Injection.TABLE")
    protected String tableName = "";
    @HopMetadataProperty(key="consistency", injectionKey="CONSISTENCY_LEVEL", injectionKeyDescription="CassandraOutput.Injection.CONSISTENCY_LEVEL")
    protected String consistency = "";
    @HopMetadataProperty(key="batch_size", injectionKey="BATCH_SIZE", injectionKeyDescription="CassandraOutput.Injection.BATCH_SIZE")
    protected String batchSize = "100";
    @HopMetadataProperty(key="unlogged_batch", injectionKey="USE_UNLOGGED_BATCH", injectionKeyDescription="CassandraOutput.Injection.USE_UNLOGGED_BATCH")
    protected boolean useUnloggedBatch = false;
    @HopMetadataProperty(key="create_table", injectionKey="CREATE_TABLE", injectionKeyDescription="CassandraOutput.Injection.CREATE_TABLE")
    protected boolean createTable = true;
    @HopMetadataProperty(key="create_table_with_clause", injectionKey="CREATE_TABLE_WITH_CLAUSE", injectionKeyDescription="CassandraOutput.Injection.CREATE_TABLE_WITH_CLAUSE")
    protected String createTableWithClause;
    @HopMetadataProperty(key="key_field", injectionKey="KEY_FIELD", injectionKeyDescription="CassandraOutput.Injection.KEY_FIELD")
    protected String keyField = "";
    @HopMetadataProperty(key="cql_batch_timeout", injectionKey="BATCH_TIMEOUT", injectionKeyDescription="CassandraOutput.Injection.BATCH_TIMEOUT")
    protected String cqlBatchInsertTimeout = "";
    @HopMetadataProperty(key="cql_sub_batch_size", injectionKey="SUB_BATCH_SIZE", injectionKeyDescription="CassandraOutput.Injection.SUB_BATCH_SIZE")
    protected String cqlSubBatchSize = "10";
    @HopMetadataProperty(key="insert_fields_not_in_meta", injectionKey="INSERT_FIELDS_NOT_IN_META", injectionKeyDescription="CassandraOutput.Injection.INSERT_FIELDS_NOT_IN_META")
    protected boolean insertFieldsNotInMeta = false;
    @HopMetadataProperty(key="update_cassandra_meta", injectionKey="UPDATE_CASSANDRA_META", injectionKeyDescription="CassandraOutput.Injection.UPDATE_CASSANDRA_META")
    protected boolean updateCassandraMeta = false;
    @HopMetadataProperty(key="truncate_table", injectionKey="TRUNCATE_TABLE", injectionKeyDescription="CassandraOutput.Injection.TRUNCATE_TABLE")
    protected boolean truncateTable = false;
    @HopMetadataProperty(key="ttl", injectionKey="TTL", injectionKeyDescription="CassandraOutput.Injection.TTL")
    protected String ttl = "";
    @HopMetadataProperty(key="ttl_unit", injectionKey="TTL_UNIT", injectionKeyDescription="CassandraOutput.Injection.TTL_UNIT", storeWithCode=true)
    protected TtlUnits ttlUnit = TtlUnits.NONE;

    public void setDefault() {
        this.schemaHost = "";
        this.schemaPort = "";
        this.tableName = "";
        this.batchSize = "10";
        this.insertFieldsNotInMeta = false;
        this.updateCassandraMeta = false;
        this.truncateTable = false;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getSchemaHost() {
        return this.schemaHost;
    }

    public void setSchemaHost(String schemaHost) {
        this.schemaHost = schemaHost;
    }

    public String getSchemaPort() {
        return this.schemaPort;
    }

    public void setSchemaPort(String schemaPort) {
        this.schemaPort = schemaPort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isUseUnloggedBatch() {
        return this.useUnloggedBatch;
    }

    public void setUseUnloggedBatch(boolean useUnloggedBatch) {
        this.useUnloggedBatch = useUnloggedBatch;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public String getCreateTableWithClause() {
        return this.createTableWithClause;
    }

    public void setCreateTableWithClause(String createTableWithClause) {
        this.createTableWithClause = createTableWithClause;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getCqlBatchInsertTimeout() {
        return this.cqlBatchInsertTimeout;
    }

    public void setCqlBatchInsertTimeout(String cqlBatchInsertTimeout) {
        this.cqlBatchInsertTimeout = cqlBatchInsertTimeout;
    }

    public String getCqlSubBatchSize() {
        return this.cqlSubBatchSize;
    }

    public void setCqlSubBatchSize(String cqlSubBatchSize) {
        this.cqlSubBatchSize = cqlSubBatchSize;
    }

    public boolean isInsertFieldsNotInMeta() {
        return this.insertFieldsNotInMeta;
    }

    public void setInsertFieldsNotInMeta(boolean insertFieldsNotInMeta) {
        this.insertFieldsNotInMeta = insertFieldsNotInMeta;
    }

    public boolean isUpdateCassandraMeta() {
        return this.updateCassandraMeta;
    }

    public void setUpdateCassandraMeta(boolean updateCassandraMeta) {
        this.updateCassandraMeta = updateCassandraMeta;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public TtlUnits getTtlUnit() {
        return this.ttlUnit;
    }

    public void setTtlUnit(TtlUnits ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TtlUnits implements IEnumHasCodeAndDescription
    {
        NONE(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.None", (String[])new String[0])){

            @Override
            long convertToSeconds(long value) {
                return -1L;
            }
        }
        ,
        SECONDS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Seconds", (String[])new String[0])){

            @Override
            long convertToSeconds(long value) {
                return value;
            }
        }
        ,
        MINUTES(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Minutes", (String[])new String[0])){

            @Override
            long convertToSeconds(long value) {
                return value * 60L;
            }
        }
        ,
        HOURS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Hours", (String[])new String[0])){

            @Override
            long convertToSeconds(long value) {
                return value * 60L * 60L;
            }
        }
        ,
        DAYS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Days", (String[])new String[0])){

            @Override
            long convertToSeconds(long value) {
                return value * 60L * 60L * 24L;
            }
        };

        private final String code = this.name();
        private final String description;

        private TtlUnits(String description) {
            this.description = description;
        }

        public static TtlUnits findWithDescription(String description) {
            for (TtlUnits value : TtlUnits.values()) {
                if (!value.getDescription().equals(description)) continue;
                return value;
            }
            return NONE;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[TtlUnits.values().length];
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = TtlUnits.values()[i].description;
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        abstract long convertToSeconds(long var1);
    }
}

