/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class InitialPipelineState
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 7685843906645495071L;
    private final @UnknownKeyFor @NonNull @Initialized Instant startTime;
    private final @UnknownKeyFor @NonNull @Initialized boolean resume;

    public InitialPipelineState(@UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized boolean resume) {
        this.startTime = startTime;
        this.resume = resume;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getStartTime() {
        return this.startTime;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isResume() {
        return this.resume;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitialPipelineState)) {
            return false;
        }
        InitialPipelineState that = (InitialPipelineState)o;
        return this.isResume() == that.isResume() && Objects.equals(this.getStartTime(), that.getStartTime());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getStartTime(), this.isResume());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "InitialPipeline{startTime=" + this.startTime + ", resume=" + this.resume + '}';
    }
}

