/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filestoresult;

import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filestoresult.FilesToResultData;
import org.apache.hop.pipeline.transforms.filestoresult.FilesToResultMeta;

public class FilesToResult
extends BaseTransform<FilesToResultMeta, FilesToResultData> {
    private static final Class<?> PKG = FilesToResultMeta.class;

    public FilesToResult(TransformMeta transformMeta, FilesToResultMeta meta, FilesToResultData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            for (ResultFile resultFile : ((FilesToResultData)this.data).filenames) {
                this.addResultFile(resultFile);
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"FilesToResult.Log.AddedNrOfFiles", (String[])new String[]{String.valueOf(((FilesToResultData)this.data).filenames.size())}));
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((FilesToResultData)this.data).filenameIndex = this.getInputRowMeta().indexOfValue(((FilesToResultMeta)this.meta).getFilenameField());
            if (((FilesToResultData)this.data).filenameIndex < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"FilesToResult.Log.CouldNotFindField", (String[])new String[]{((FilesToResultMeta)this.meta).getFilenameField()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        String filename = this.getInputRowMeta().getString(r, ((FilesToResultData)this.data).filenameIndex);
        try {
            ResultFile resultFile = new ResultFile(((FilesToResultMeta)this.meta).getFileType() == null ? ResultFile.FileType.GENERAL.getType() : ((FilesToResultMeta)this.meta).getFileType().getType(), HopVfs.getFileObject((String)filename, (IVariables)this.variables), this.getPipeline().getPipelineMeta().getName(), this.getTransformName());
            ((FilesToResultData)this.data).filenames.add(resultFile);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        ((FilesToResultData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        ((FilesToResultMeta)this.meta).getFields(((FilesToResultData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        this.putRow(((FilesToResultData)this.data).outputRowMeta, r);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FilesToResult.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }
}

