/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.apache.hc.client5.http.impl.routing;

import com.clickhouse.client.internal.apache.hc.client5.http.HttpRoute;
import com.clickhouse.client.internal.apache.hc.client5.http.SchemePortResolver;
import com.clickhouse.client.internal.apache.hc.client5.http.config.RequestConfig;
import com.clickhouse.client.internal.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import com.clickhouse.client.internal.apache.hc.client5.http.protocol.HttpClientContext;
import com.clickhouse.client.internal.apache.hc.client5.http.routing.HttpRoutePlanner;
import com.clickhouse.client.internal.apache.hc.client5.http.routing.RoutingSupport;
import com.clickhouse.client.internal.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpException;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpHost;
import com.clickhouse.client.internal.apache.hc.core5.http.ProtocolException;
import com.clickhouse.client.internal.apache.hc.core5.http.URIScheme;
import com.clickhouse.client.internal.apache.hc.core5.http.protocol.HttpContext;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public final HttpRoute determineRoute(HttpHost host, HttpContext context) throws HttpException {
        HttpHost target;
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, context);
        }
        if ((target = RoutingSupport.normalize(host, this.schemePortResolver)).getPort() < 0) {
            throw new ProtocolException("Unroutable protocol scheme: " + target);
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase(URIScheme.HTTPS.getId());
        if (proxy == null) {
            return new HttpRoute(target, this.determineLocalAddress(target, context), secure);
        }
        return new HttpRoute(target, this.determineLocalAddress(proxy, context), proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        return null;
    }

    protected InetAddress determineLocalAddress(HttpHost firstHop, HttpContext context) throws HttpException {
        return null;
    }
}

