/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc.types;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public final class URL
implements SQLData {
    private String url;

    @Override
    public String getSQLTypeName() {
        return "url";
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        if (!"url".equals(string)) {
            throw new SQLException("can only use this class with 'url' type", "M1M05");
        }
        this.url = sQLInput.readString();
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeString(this.url);
    }

    public String toString() {
        return this.url;
    }

    public void fromString(String string) throws Exception {
        if (string == null) {
            this.url = string;
            return;
        }
        new URI(string).toURL();
        this.url = string;
    }

    public java.net.URL getURL() throws SQLDataException {
        if (this.url == null) {
            return null;
        }
        try {
            return new URI(this.url).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new SQLDataException("data is not a valid URL: " + exception.getMessage(), "22M30");
        }
    }

    public void setURL(java.net.URL uRL) {
        this.url = uRL.toString();
    }
}

