/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.RetryContext;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.util.ThrowingBiFunction;

@SnowflakeJdbcInternalApi
public class RetryContextManager {
    private final List<ThrowingBiFunction<HttpRequestBase, RetryContext, RetryContext, SnowflakeSQLException>> retryCallbacks = new ArrayList<ThrowingBiFunction<HttpRequestBase, RetryContext, RetryContext, SnowflakeSQLException>>();
    private final RetryHook retryHook;
    private RetryContext retryContext;

    public RetryContextManager() {
        this(RetryHook.ALWAYS_BEFORE_RETRY);
    }

    public RetryContextManager(RetryHook retryHook) {
        this.retryHook = retryHook;
        this.retryContext = new RetryContext();
    }

    public RetryContextManager registerRetryCallback(ThrowingBiFunction<HttpRequestBase, RetryContext, RetryContext, SnowflakeSQLException> callback) {
        this.retryCallbacks.add(callback);
        return this;
    }

    protected void executeRetryCallbacks(HttpRequestBase requestToRetry) throws SnowflakeSQLException {
        for (ThrowingBiFunction<HttpRequestBase, RetryContext, RetryContext, SnowflakeSQLException> callback : this.retryCallbacks) {
            this.retryContext = callback.apply(requestToRetry, this.retryContext);
        }
    }

    public RetryHook getRetryHook() {
        return this.retryHook;
    }

    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public static enum RetryHook {
        ALWAYS_BEFORE_RETRY;

    }
}

