/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.FixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.RepeatedFixedWidthVectorLike;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.RepeatedVariableWidthVectorLike;

public class AllocationHelper {
    private AllocationHelper() {
    }

    public static void allocate(ValueVector v, int valueCount, int bytesPerValue) {
        AllocationHelper.allocate(v, valueCount, bytesPerValue, 5);
    }

    public static void allocatePrecomputedChildCount(ValueVector v, int valueCount, int bytesPerValue, int childValCount) {
        if (v instanceof FixedWidthVector) {
            ((FixedWidthVector)v).allocateNew(valueCount);
        } else if (v instanceof VariableWidthVector) {
            ((VariableWidthVector)v).allocateNew(valueCount * bytesPerValue, valueCount);
        } else if (v instanceof RepeatedFixedWidthVectorLike) {
            ((RepeatedFixedWidthVectorLike)((Object)v)).allocateNew(valueCount, childValCount);
        } else if (v instanceof RepeatedVariableWidthVectorLike) {
            ((RepeatedVariableWidthVectorLike)((Object)v)).allocateNew(childValCount * bytesPerValue, valueCount, childValCount);
        } else {
            v.allocateNew();
        }
    }

    public static void allocate(ValueVector v, int valueCount, int bytesPerValue, int repeatedPerTop) {
        AllocationHelper.allocatePrecomputedChildCount(v, valueCount, bytesPerValue, repeatedPerTop * valueCount);
    }

    public static void allocateNew(ValueVector v, int valueCount) {
        if (v instanceof FixedWidthVector) {
            ((FixedWidthVector)v).allocateNew(valueCount);
        } else if (v instanceof VariableWidthVector) {
            ((VariableWidthVector)v).allocateNew(valueCount);
        } else {
            v.allocateNew();
        }
    }
}

