/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.pooling;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.pooling.SnowflakePooledConnection;

class LogicalConnection
implements Connection {
    private static final SFLogger logger = SFLoggerFactory.getLogger(LogicalConnection.class);
    private final Connection physicalConnection;
    private final SnowflakePooledConnection pooledConnection;
    private boolean isClosed;

    LogicalConnection(SnowflakePooledConnection pooledConnection) throws SQLException {
        this.physicalConnection = pooledConnection.getPhysicalConnection();
        this.pooledConnection = pooledConnection;
        this.isClosed = this.physicalConnection.isClosed();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createStatement();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareCall(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getAutoCommit();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        SnowflakeConnectionV1 sfConnection = this.physicalConnection.unwrap(SnowflakeConnectionV1.class);
        logger.debug("Closing logical connection with session id: {}", sfConnection.getSessionID());
        this.pooledConnection.fireConnectionCloseEvent();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getMetaData();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.isReadOnly();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getCatalog();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getWarnings();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.clearWarnings();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getTypeMap();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setTypeMap(map);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getHoldability();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.setSavepoint();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.setSavepoint(name);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.rollback(savepoint);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createClob();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createBlob();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createNClob();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createSQLXML();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return !this.isClosed && this.physicalConnection.isValid(timeout);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.physicalConnection.setClientInfo(name, value);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.physicalConnection.setClientInfo(properties);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.physicalConnection.getClientInfo(name);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getClientInfo();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setSchema(schema);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getSchema();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.physicalConnection.abort(executor);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.throwExceptionIfClosed();
        try {
            this.physicalConnection.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.throwExceptionIfClosed();
        try {
            return this.physicalConnection.getNetworkTimeout();
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.physicalConnection.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.physicalConnection.unwrap(iface);
        }
        catch (SQLException e) {
            this.pooledConnection.fireConnectionErrorEvent(e);
            throw e;
        }
    }

    private void throwExceptionIfClosed() throws SQLException {
        if (this.isClosed) {
            throw new SnowflakeSQLException(ErrorCode.CONNECTION_CLOSED, new Object[0]);
        }
    }
}

