/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.resolver.VariableResolver;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Variables
implements IVariables {
    private Map<String, String> properties = Collections.synchronizedMap(new HashMap());
    private IVariables parent = null;
    private Map<String, String> injection = null;
    private boolean initialized = false;

    @Override
    public void copyFrom(IVariables variables) {
        if (variables != null && this != variables) {
            String[] variableNames = variables.getVariableNames();
            for (int idx = 0; idx < variableNames.length; ++idx) {
                this.properties.put(variableNames[idx], variables.getVariable(variableNames[idx]));
            }
        }
    }

    @Override
    public IVariables getParentVariables() {
        return this.parent;
    }

    @Override
    public void setParentVariables(IVariables parent) {
        this.parent = parent;
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        String value = this.properties.get(variableName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getVariable(String variableName) {
        return this.properties.get(variableName);
    }

    @Override
    public boolean getVariableBoolean(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty(variableName) && !Utils.isEmpty(value = this.properties.get(variableName))) {
            return ValueMetaBase.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeFrom(IVariables parent) {
        this.parent = parent;
        Set<String> systemPropertiesNames = System.getProperties().stringPropertyNames();
        for (String key : systemPropertiesNames) {
            this.getProperties().put(key, System.getProperties().getProperty(key));
        }
        List<DescribedVariable> describedVariables = HopConfig.getInstance().getDescribedVariables();
        for (DescribedVariable describedVariable : describedVariables) {
            this.getProperties().put(describedVariable.getName(), describedVariable.getValue());
        }
        if (parent != null) {
            this.copyFrom(parent);
        }
        if (this.injection != null) {
            this.getProperties().putAll(this.injection);
            this.injection = null;
        }
        this.initialized = true;
    }

    @Override
    public String[] getVariableNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[0]);
    }

    @Override
    public synchronized void setVariable(String variableName, String variableValue) {
        if (variableValue != null) {
            this.properties.put(variableName, variableValue);
        } else {
            this.properties.remove(variableName);
        }
    }

    @Override
    public synchronized String resolve(String aString) {
        if (aString == null || aString.isEmpty()) {
            return aString;
        }
        String resolved = StringUtil.environmentSubstitute(aString, this.properties);
        String r = this.substituteVariableResolvers(resolved);
        if (r != null) {
            resolved = r;
        }
        return resolved;
    }

    private String substituteVariableResolvers(String input) {
        Object resolved = input;
        int startIndex = 0;
        while (startIndex < ((String)resolved).length()) {
            String arguments;
            String name;
            int resolverIndex = ((String)resolved).indexOf("#{");
            if (resolverIndex < 0) {
                return null;
            }
            int closeIndex = ((String)resolved).indexOf("}", resolverIndex);
            if (closeIndex < 0) {
                return null;
            }
            int colonIndex = ((String)resolved).indexOf(58, resolverIndex);
            if (colonIndex >= 0) {
                name = ((String)resolved).substring(resolverIndex + "#{".length(), colonIndex);
                arguments = ((String)resolved).substring(colonIndex + 1, closeIndex);
            } else {
                name = ((String)resolved).substring(resolverIndex + "#{".length(), closeIndex);
                arguments = "";
            }
            try {
                String resolvedArgument;
                MultiMetadataProvider provider = HopMetadataInstance.getMetadataProvider();
                IHopMetadataSerializer<VariableResolver> serializer = provider.getSerializer(VariableResolver.class);
                VariableResolver resolver = serializer.load(name);
                if (resolver == null) {
                    if (LogChannel.GENERAL.isDetailed()) {
                        LogChannel.GENERAL.logDetailed("WARNING: Variable Resolver '" + name + "' could not be found in the metadata");
                    }
                    return resolved;
                }
                String secretValue = null;
                String[] parameters = arguments.split(":");
                String secretPath = parameters[0];
                if (parameters.length > 1) {
                    secretValue = parameters[1];
                }
                if (StringUtils.isEmpty((String)(resolvedArgument = resolver.getIResolver().resolve(secretPath, this)))) {
                    return resolved;
                }
                if (StringUtils.isEmpty((String)secretValue)) {
                    return resolvedArgument;
                }
                try {
                    JSONObject js = (JSONObject)new JSONParser().parse(resolvedArgument);
                    Object value = js.get((Object)secretValue);
                    resolvedArgument = value == null ? "" : value.toString();
                }
                catch (Exception e) {
                    LogChannel.GENERAL.logError("Error parsing JSON '" + resolvedArgument + "} to retrieve secret value '" + secretValue + "'", e);
                }
                String before = ((String)resolved).substring(0, resolverIndex);
                String after = ((String)resolved).substring(closeIndex + 1);
                resolved = before + resolvedArgument + after;
                startIndex = before.length() + resolvedArgument.length();
            }
            catch (HopException e) {
                throw new RuntimeException("Error resolving variable '" + input + "' with variable resolver metadata", e);
            }
        }
        return resolved;
    }

    @Override
    public String resolve(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        if (aString == null || aString.isEmpty()) {
            return aString;
        }
        return StringUtil.substituteField(aString, rowMeta, rowData);
    }

    @Override
    public String[] resolve(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = this.resolve(string[i]);
        }
        return retval;
    }

    @Override
    public void shareWith(IVariables variables) {
    }

    @Override
    public void setVariables(Map<String, String> map) {
        if (this.initialized) {
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (Utils.isEmpty(entry.getKey())) continue;
                    this.properties.put(entry.getKey(), Const.NVL(entry.getValue(), ""));
                }
                this.injection = null;
            }
        } else {
            this.injection = new Hashtable<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (Utils.isEmpty(entry.getKey())) continue;
                this.injection.put(entry.getKey(), Const.NVL(entry.getValue(), ""));
            }
        }
    }

    public static synchronized IVariables getADefaultVariableSpace() {
        Variables variables = new Variables();
        variables.initializeFrom(null);
        return variables;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }
}

