/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannelFileWriterBuffer;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.vfs.HopVfs;

public class LogChannelFileWriter {
    private String logChannelId;
    private FileObject logFile;
    private boolean appending;
    private int pollingInterval;
    private AtomicBoolean active;
    private AtomicBoolean finished;
    private HopException exception;
    protected OutputStream logFileOutputStream;
    private LogChannelFileWriterBuffer buffer;

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending, int pollingInterval) throws HopException {
        this.logChannelId = logChannelId;
        this.logFile = logFile;
        this.appending = appending;
        this.pollingInterval = pollingInterval;
        this.active = new AtomicBoolean(false);
        this.finished = new AtomicBoolean(false);
        try {
            this.logFileOutputStream = HopVfs.getOutputStream((FileObject)logFile, (boolean)appending);
        }
        catch (IOException e) {
            throw new HopException("There was an error while trying to open file '" + String.valueOf(logFile) + "' for writing", (Throwable)e);
        }
        this.buffer = new LogChannelFileWriterBuffer(this.logChannelId);
        LoggingRegistry.getInstance().registerLogChannelFileWriterBuffer(this.buffer);
    }

    public LogChannelFileWriter(String logChannelId, FileObject logFile, boolean appending) throws HopException {
        this(logChannelId, logFile, appending, 1000);
    }

    public void startLogging() {
        this.exception = null;
        this.active.set(true);
        Thread thread = new Thread(() -> {
            try {
                while (this.active.get() && this.exception == null) {
                    this.flush();
                    Thread.sleep(this.pollingInterval);
                }
                this.flush();
                return;
            }
            catch (Exception e) {
                this.exception = new HopException("There was an error logging to file '" + String.valueOf(this.logFile) + "'", (Throwable)e);
                return;
            }
            finally {
                try {
                    if (this.logFileOutputStream != null) {
                        this.logFileOutputStream.close();
                        this.logFileOutputStream = null;
                    }
                    if (this.buffer != null) {
                        LoggingRegistry.getInstance().removeLogChannelFileWriterBuffer(this.buffer.getLogChannelId());
                    }
                }
                catch (Exception e) {
                    this.exception = new HopException("There was an error closing log file file '" + String.valueOf(this.logFile) + "'", (Throwable)e);
                }
                finally {
                    this.finished.set(true);
                }
            }
        });
        thread.start();
    }

    public synchronized void flush() {
        try {
            StringBuffer buffer = this.buffer.getBuffer();
            this.logFileOutputStream.write(buffer.toString().getBytes());
            this.logFileOutputStream.flush();
        }
        catch (Exception e) {
            this.exception = new HopException("There was an error logging to file '" + String.valueOf(this.logFile) + "'", (Throwable)e);
        }
    }

    public void stopLogging() {
        this.flush();
        this.active.set(false);
        while (!this.finished.get()) {
            Thread.yield();
        }
        if (this.buffer != null) {
            LoggingRegistry.getInstance().removeLogChannelFileWriterBuffer(this.buffer.getLogChannelId());
        }
    }

    public HopException getException() {
        return this.exception;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public FileObject getLogFile() {
        return this.logFile;
    }

    public void setLogFile(FileObject logFile) {
        this.logFile = logFile;
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending(boolean appending) {
        this.appending = appending;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }
}

