/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class UserGeneratedTag {
    @Nonnull
    protected final String tagText;

    public UserGeneratedTag(@Nonnull String tagText) {
        if (tagText == null) {
            throw new IllegalArgumentException("Required value for 'tagText' is null");
        }
        if (tagText.length() < 1) {
            throw new IllegalArgumentException("String 'tagText' is shorter than 1");
        }
        if (tagText.length() > 32) {
            throw new IllegalArgumentException("String 'tagText' is longer than 32");
        }
        if (!Pattern.matches("[\\w]+", tagText)) {
            throw new IllegalArgumentException("String 'tagText' does not match pattern");
        }
        this.tagText = tagText;
    }

    @Nonnull
    public String getTagText() {
        return this.tagText;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tagText});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserGeneratedTag other = (UserGeneratedTag)obj;
            return this.tagText == other.tagText || this.tagText.equals(other.tagText);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserGeneratedTag> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserGeneratedTag value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("tag_text");
            StoneSerializers.string().serialize(value.tagText, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserGeneratedTag deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_tagText;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_tagText = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("tag_text".equals(field)) {
                        f_tagText = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_tagText == null) {
                    throw new JsonParseException(p, "Required field \"tag_text\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserGeneratedTag value = new UserGeneratedTag(f_tagText);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

