/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.beam.sdk.transforms.windowing.AfterSynchronizedProcessingTime;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampTransform;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class AfterProcessingTime
extends Trigger.OnceTrigger {
    private static final @UnknownKeyFor @NonNull @Initialized PeriodFormatter DURATION_FORMATTER = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampTransform> timestampTransforms;

    private AfterProcessingTime(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampTransform> timestampTransforms) {
        super(null);
        this.timestampTransforms = timestampTransforms;
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterProcessingTime pastFirstElementInPane() {
        return new AfterProcessingTime(Collections.emptyList());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampTransform> getTimestampTransforms() {
        return this.timestampTransforms;
    }

    public @UnknownKeyFor @NonNull @Initialized AfterProcessingTime plusDelayOf(@UnknownKeyFor @NonNull @Initialized Duration delay) {
        return new AfterProcessingTime((List<TimestampTransform>)ImmutableList.builder().addAll(this.timestampTransforms).add((Object)TimestampTransform.delay(delay)).build());
    }

    public @UnknownKeyFor @NonNull @Initialized AfterProcessingTime alignedTo(@UnknownKeyFor @NonNull @Initialized Duration period, @UnknownKeyFor @NonNull @Initialized Instant offset) {
        return new AfterProcessingTime((List<TimestampTransform>)ImmutableList.builder().addAll(this.timestampTransforms).add((Object)TimestampTransform.alignTo(period, offset)).build());
    }

    public @UnknownKeyFor @NonNull @Initialized AfterProcessingTime alignedTo(@UnknownKeyFor @NonNull @Initialized Duration period) {
        return this.alignedTo(period, new Instant(0L));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized Trigger other) {
        return this.equals(other);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return AfterSynchronizedProcessingTime.ofFirstElement();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (TimestampTransform transform : this.getTimestampTransforms()) {
            if (transform instanceof TimestampTransform.Delay) {
                TimestampTransform.Delay delay = (TimestampTransform.Delay)transform;
                builder.append(".plusDelayOf(").append(DURATION_FORMATTER.print((ReadablePeriod)delay.getDelay().toPeriod())).append(")");
                continue;
            }
            if (!(transform instanceof TimestampTransform.AlignTo)) continue;
            TimestampTransform.AlignTo alignTo = (TimestampTransform.AlignTo)transform;
            builder.append(".alignedTo(").append(DURATION_FORMATTER.print((ReadablePeriod)alignTo.getPeriod().toPeriod())).append(", ").append(alignTo.getOffset()).append(")");
        }
        return builder.toString();
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTime)) {
            return false;
        }
        AfterProcessingTime that = (AfterProcessingTime)obj;
        return this.getTimestampTransforms().equals(that.getTimestampTransforms());
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getTimestampTransforms());
    }
}

