/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals;

import org.apache.commons.lang3.StringUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;

public enum ModelType {
    OPEN_AI("OPEN_AI", i18nUtil.i18n("LanguageModelChatDialog.ModelType.OPEN_AI")),
    ANTHROPIC("ANTHROPIC", i18nUtil.i18n("LanguageModelChatDialog.ModelType.ANTHROPIC")),
    OLLAMA("OLLAMA", i18nUtil.i18n("LanguageModelChatDialog.ModelType.OLLAMA")),
    MISTRAL("MISTRAL", i18nUtil.i18n("LanguageModelChatDialog.ModelType.MISTRAL")),
    HUGGING_FACE("HUGGING_FACE", i18nUtil.i18n("LanguageModelChatDialog.ModelType.HUGGING_FACE"));

    private String code;
    private String description;

    private ModelType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static ModelType typeFromDescription(String description) {
        for (ModelType type : ModelType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)type.description, (CharSequence)description)) continue;
            return type;
        }
        return OPEN_AI;
    }

    public static String[] modelTypeDescriptions() {
        ModelType[] types = ModelType.values();
        String[] descriptions = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            descriptions[i] = types[i].description;
        }
        return descriptions;
    }

    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }
}

