/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.util.AbstractAutoCloseableRegistry;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;

@Internal
public class CloseableRegistry
extends AbstractAutoCloseableRegistry<Closeable, Closeable, Object, IOException>
implements Closeable {
    private static final Object DUMMY = new Object();

    public CloseableRegistry() {
        super(new LinkedHashMap());
    }

    @Override
    protected void doRegister(@Nonnull Closeable closeable, @Nonnull Map<Closeable, Object> closeableMap) {
        closeableMap.put(closeable, DUMMY);
    }

    @Override
    protected boolean doUnRegister(@Nonnull Closeable closeable, @Nonnull Map<Closeable, Object> closeableMap) {
        return closeableMap.remove(closeable) != null;
    }

    @Override
    public void doClose(List<Closeable> toClose) throws IOException {
        IOUtils.closeAllQuietly(Lists.reverse(toClose));
    }

    public void unregisterAndCloseAll(Closeable ... toUnregisterAndClose) throws IOException {
        IOException suppressed = null;
        for (Closeable closeable : toUnregisterAndClose) {
            if (!this.unregisterCloseable(closeable)) continue;
            try {
                closeable.close();
            }
            catch (IOException ex) {
                suppressed = ExceptionUtils.firstOrSuppressed(ex, suppressed);
            }
        }
        if (suppressed != null) {
            throw suppressed;
        }
    }
}

