/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.neo4j.transforms.cypherbuilder.ReturnValue;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.OperationType;

public class ReturnOperation
implements IOperation {
    @HopMetadataProperty
    private String name;
    @HopMetadataProperty
    private OperationType operationType;
    @HopMetadataProperty
    private List<ReturnValue> returnValues;

    public ReturnOperation() {
        this.operationType = OperationType.RETURN;
        this.returnValues = new ArrayList<ReturnValue>();
    }

    public ReturnOperation(String name, List<ReturnValue> returnValues) {
        this.name = name;
        this.returnValues = returnValues;
    }

    public ReturnOperation(ReturnOperation o) {
        this();
        this.name = o.name;
        o.returnValues.forEach(v -> this.returnValues.add(new ReturnValue((ReturnValue)v)));
    }

    @Override
    public ReturnOperation clone() {
        return new ReturnOperation(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnOperation that = (ReturnOperation)o;
        if (this.operationType != that.operationType) {
            return false;
        }
        if (this.returnValues.size() != that.returnValues.size()) {
            return false;
        }
        for (int i = 0; i < this.returnValues.size(); ++i) {
            if (this.returnValues.get(i).equals(that.returnValues.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationType, this.returnValues});
    }

    @Override
    public String getCypherClause(String unwindAlias, List<Parameter> parameters) throws HopException {
        StringBuilder cypher = new StringBuilder(this.operationType.keyWord());
        for (int r = 0; r < this.returnValues.size(); ++r) {
            ReturnValue returnValue = this.returnValues.get(r);
            if (r > 0) {
                cypher.append(",");
            }
            cypher.append(" ").append(returnValue.getCypherClause());
        }
        cypher.append(" ");
        return cypher.toString();
    }

    @Override
    public boolean needsWriteTransaction() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public List<ReturnValue> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List<ReturnValue> returnValues) {
        this.returnValues = returnValues;
    }
}

