/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.GrowableOffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DetectNewPartitionsTracker
extends GrowableOffsetRangeTracker {
    public DetectNewPartitionsTracker(@UnknownKeyFor @NonNull @Initialized long start) {
        super(start, (GrowableOffsetRangeTracker.RangeEndEstimator)new UnboundedRangeEndEstimator());
    }

    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        if (fractionOfRemainder != 0.0) {
            return null;
        }
        return super.trySplit(fractionOfRemainder);
    }

    private static class UnboundedRangeEndEstimator
    implements GrowableOffsetRangeTracker.RangeEndEstimator {
        private UnboundedRangeEndEstimator() {
        }

        public @UnknownKeyFor @NonNull @Initialized long estimate() {
            return Long.MAX_VALUE;
        }
    }
}

