/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Ticker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class LimitingTopicBacklogReader
implements TopicBacklogReader {
    private final @UnknownKeyFor @NonNull @Initialized TopicBacklogReader underlying;
    private final @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse> backlogCache;
    @Nullable
    @GuardedBy(value="this")
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Offset currentRequestOffset = null;

    LimitingTopicBacklogReader(@UnknownKeyFor @NonNull @Initialized TopicBacklogReader underlying, @UnknownKeyFor @NonNull @Initialized Ticker ticker) {
        this.underlying = underlying;
        this.backlogCache = CacheBuilder.newBuilder().ticker(ticker).maximumSize(1L).expireAfterWrite(1L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, ComputeMessageStatsResponse>(){

            public @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse load(@UnknownKeyFor @NonNull @Initialized String val) {
                return LimitingTopicBacklogReader.this.loadFromUnderlying();
            }
        });
    }

    private synchronized @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse loadFromUnderlying() {
        return this.underlying.computeMessageStats((Offset)Preconditions.checkNotNull((Object)this.currentRequestOffset));
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized ComputeMessageStatsResponse computeMessageStats(@UnknownKeyFor @NonNull @Initialized Offset offset) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        this.currentRequestOffset = offset;
        try {
            return (ComputeMessageStatsResponse)this.backlogCache.get((Object)"cache");
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.underlying.close();
    }
}

