/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatRecordAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HeartbeatRecordAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    HeartbeatRecordAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.metrics = metrics;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized HeartbeatRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        String token = partition.getPartitionToken();
        LOG.debug("[{}] Processing heartbeat record {}", (Object)token, (Object)record);
        Timestamp timestamp = record.getTimestamp();
        Instant timestampInstant = new Instant(timestamp.toSqlTimestamp().getTime());
        if (!tracker.tryClaim((Object)timestamp)) {
            LOG.debug("[{}] Could not claim queryChangeStream({}), stopping", (Object)token, (Object)timestamp);
            return Optional.of(DoFn.ProcessContinuation.stop());
        }
        this.metrics.incHeartbeatRecordCount();
        watermarkEstimator.setWatermark(timestampInstant);
        LOG.debug("[{}] Heartbeat record action completed successfully", (Object)token);
        return Optional.empty();
    }
}

