/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmloutput;

import com.google.common.base.Enums;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaBase;

public class XmlField
implements Cloneable {
    @Injection(name="OUTPUT_FIELDNAME", group="OUTPUT_FIELDS")
    private String fieldName;
    @Injection(name="OUTPUT_ELEMENTNAME", group="OUTPUT_FIELDS")
    private String elementName;
    private int type;
    @Injection(name="OUTPUT_FORMAT", group="OUTPUT_FIELDS")
    private String format;
    @Injection(name="OUTPUT_LENGTH", group="OUTPUT_FIELDS")
    private int length;
    @Injection(name="OUTPUT_PRECISION", group="OUTPUT_FIELDS")
    private int precision;
    @Injection(name="OUTPUT_CURRENCY", group="OUTPUT_FIELDS")
    private String currencySymbol;
    @Injection(name="OUTPUT_DECIMAL", group="OUTPUT_FIELDS")
    private String decimalSymbol;
    @Injection(name="OUTPUT_GROUP", group="OUTPUT_FIELDS")
    private String groupingSymbol;
    @Injection(name="OUTPUT_NULL", group="OUTPUT_FIELDS")
    private String nullString;
    @Injection(name="OUTPUT_CONTENT_TYPE", group="OUTPUT_FIELDS")
    private ContentType contentType;

    public XmlField(ContentType contentType, String fieldName, String elementName, int type, String format, int length, int precision, String currencySymbol, String decimalSymbol, String groupSymbol, String nullString) {
        this.contentType = contentType;
        this.fieldName = fieldName;
        this.elementName = elementName;
        this.type = type;
        this.format = format;
        this.length = length;
        this.precision = precision;
        this.currencySymbol = currencySymbol;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupSymbol;
        this.nullString = nullString;
    }

    public XmlField() {
        this.contentType = ContentType.Element;
    }

    public int compare(Object obj) {
        XmlField field = (XmlField)obj;
        return this.fieldName.compareTo(field.getFieldName());
    }

    public boolean equal(Object obj) {
        XmlField field = (XmlField)obj;
        return this.fieldName.equals(field.getFieldName());
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldname) {
        this.fieldName = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaBase.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="OUTPUT_TYPE", group="OUTPUT_FIELDS")
    public void setType(String typeDesc) {
        this.type = ValueMetaBase.getType((String)typeDesc);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupSymbol) {
        this.groupingSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String toString() {
        return this.fieldName + ":" + this.getTypeDesc() + ":" + this.elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public static enum ContentType {
        Element,
        Attribute;


        public static ContentType getIfPresent(String contentType) {
            return (ContentType)((Object)Enums.getIfPresent(ContentType.class, (String)contentType).or((Object)Element));
        }
    }
}

