/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.transforms.exectests;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.gui.TestingGuiPlugin;
import org.apache.hop.testing.transforms.exectests.ExecuteTestsData;
import org.apache.hop.testing.transforms.exectests.ExecuteTestsMeta;
import org.apache.hop.testing.util.UnitTestUtil;

public class ExecuteTests
extends BaseTransform<ExecuteTestsMeta, ExecuteTestsData> {
    public ExecuteTests(TransformMeta transformMeta, ExecuteTestsMeta meta, ExecuteTestsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        try {
            ((ExecuteTestsData)this.data).hasPrevious = false;
            TransformMeta[] prevTransforms = this.getPipelineMeta().getPrevTransforms(this.getTransformMeta());
            if (prevTransforms.length > 0) {
                ((ExecuteTestsData)this.data).hasPrevious = true;
                if (StringUtils.isEmpty((String)((ExecuteTestsMeta)this.meta).getTestNameInputField())) {
                    this.logError("When this transform receives input it wants the name of a field to get the unit test name from to determine which transforms to execute");
                    this.setErrors(1L);
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.logError("Error analyzing ", e);
            this.setErrors(1L);
            return false;
        }
        return super.init();
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            IHopMetadataSerializer testSerializer = this.metadataProvider.getSerializer(PipelineUnitTest.class);
            if (((ExecuteTestsData)this.data).hasPrevious) {
                ((ExecuteTestsData)this.data).tests = new ArrayList<PipelineUnitTest>();
                Object[] row = this.getRow();
                if (row == null) {
                    this.setOutputDone();
                    return false;
                }
                int inputFieldIndex = this.getInputRowMeta().indexOfValue(((ExecuteTestsMeta)this.meta).getTestNameInputField());
                if (inputFieldIndex < 0) {
                    throw new HopException("Unable to find test name field '" + ((ExecuteTestsMeta)this.meta).getTestNameInputField() + "' in the input");
                }
                while (row != null) {
                    String testName = this.getInputRowMeta().getString(row, inputFieldIndex);
                    try {
                        PipelineUnitTest pipelineUnitTest = (PipelineUnitTest)testSerializer.load(testName);
                        ((ExecuteTestsData)this.data).tests.add(pipelineUnitTest);
                    }
                    catch (Exception e2) {
                        throw new HopException("Unable to load test '" + testName + "'", (Throwable)e2);
                    }
                    row = this.getRow();
                }
            } else {
                try {
                    ((ExecuteTestsData)this.data).tests = new ArrayList<PipelineUnitTest>();
                    for (String testName : testSerializer.listObjectNames()) {
                        PipelineUnitTest pipelineUnitTest = (PipelineUnitTest)testSerializer.load(testName);
                        if (((ExecuteTestsMeta)this.meta).getTypeToExecute() != null && ((ExecuteTestsMeta)this.meta).getTypeToExecute() != pipelineUnitTest.getType()) continue;
                        ((ExecuteTestsData)this.data).tests.add(pipelineUnitTest);
                    }
                }
                catch (HopException e3) {
                    throw new HopException("Unable to read pipeline unit tests from the metadata", (Throwable)e3);
                }
            }
            ((ExecuteTestsData)this.data).testsIterator = ((ExecuteTestsData)this.data).tests.iterator();
            ((ExecuteTestsData)this.data).outputRowMeta = new RowMeta();
            ((ExecuteTestsMeta)this.meta).getFields(((ExecuteTestsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (((ExecuteTestsData)this.data).testsIterator.hasNext()) {
            PipelineUnitTest test = ((ExecuteTestsData)this.data).testsIterator.next();
            UnitTestUtil.executeUnitTest(test, (ILoggingObject)this, this.getLogLevel(), new Result(), this.metadataProvider, (IVariables)this, (pipeline, pipelineResult) -> {
                if (pipelineResult.getNrErrors() != 0L) {
                    Object[] row = RowDataUtil.allocateRowData((int)((ExecuteTestsData)this.data).outputRowMeta.size());
                    int index = 0;
                    row[index++] = pipeline.getPipelineMeta().getName();
                    row[index++] = null;
                    row[index++] = null;
                    row[index++] = null;
                    row[index++] = Boolean.TRUE;
                    row[index++] = pipelineResult.getLogText();
                    this.putRow(((ExecuteTestsData)this.data).outputRowMeta, row);
                }
            }, (pipeline, testResults) -> {
                for (UnitTestResult testResult : testResults) {
                    Object[] row = RowDataUtil.allocateRowData((int)((ExecuteTestsData)this.data).outputRowMeta.size());
                    int index = 0;
                    row[index++] = testResult.getPipelineName();
                    row[index++] = testResult.getUnitTestName();
                    row[index++] = testResult.getDataSetName();
                    row[index++] = testResult.getTransformName();
                    row[index++] = testResult.isError();
                    row[index++] = testResult.getComment();
                    this.putRow(((ExecuteTestsData)this.data).outputRowMeta, row);
                }
            }, (test1, testPipelineMeta, e) -> {
                Object[] row = RowDataUtil.allocateRowData((int)((ExecuteTestsData)this.data).outputRowMeta.size());
                int index = 0;
                row[index++] = testPipelineMeta == null ? null : testPipelineMeta.getName();
                row[index++] = test1.getName();
                row[index++] = null;
                row[index++] = null;
                row[index++] = Boolean.TRUE;
                row[index++] = e.getMessage() + " : " + Const.getStackTracker((Throwable)e);
                this.putRow(((ExecuteTestsData)this.data).outputRowMeta, row);
            });
            return true;
        }
        this.setOutputDone();
        return false;
    }

    private PipelineMeta loadTestPipeline(PipelineUnitTest test) throws HopException {
        PipelineMeta unitTestPipelineMeta = null;
        String filename = test.calculateCompletePipelineFilename((IVariables)this);
        if (StringUtils.isNotEmpty((String)filename)) {
            unitTestPipelineMeta = new PipelineMeta(filename, this.metadataProvider, (IVariables)this);
        }
        if (unitTestPipelineMeta == null) {
            throw new HopException("Unable to find a valid pipeline filename in unit test '" + test.getName() + "'");
        }
        unitTestPipelineMeta.setMetadataProvider(this.metadataProvider);
        TestingGuiPlugin.selectUnitTest(unitTestPipelineMeta, test);
        return unitTestPipelineMeta;
    }
}

