/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.SetMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final @UnknownKeyFor @NonNull @Initialized TransformHierarchy transforms;
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> usedFullNames = new HashSet<String>();
    private @Nullable @UnknownKeyFor @Initialized CoderRegistry coderRegistry;
    private @Nullable @UnknownKeyFor @Initialized SchemaRegistry schemaRegistry;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> instancePerName = ArrayListMultimap.create();
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions defaultOptions;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> errorHandlers = new ArrayList();

    public static @UnknownKeyFor @NonNull @Initialized Pipeline create() {
        Pipeline pipeline = new Pipeline(PipelineOptionsFactory.create());
        LOG.debug("Creating {}", (Object)pipeline);
        return pipeline;
    }

    public static @UnknownKeyFor @NonNull @Initialized Pipeline create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        PipelineRunner.fromOptions(options);
        Pipeline pipeline = new Pipeline(options);
        LOG.debug("Creating {}", (Object)pipeline);
        return pipeline;
    }

    public @UnknownKeyFor @NonNull @Initialized PBegin begin() {
        return PBegin.in(this);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PBegin, OutputT> root) {
        return this.begin().apply(root);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PBegin, OutputT> root) {
        return this.begin().apply(name, root);
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized Pipeline forTransformHierarchy(@UnknownKeyFor @NonNull @Initialized TransformHierarchy transforms, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new Pipeline(transforms, options);
    }

    @Internal
    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions() {
        return this.defaultOptions;
    }

    @Internal
    public void replaceAll(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PTransformOverride> overrides) {
        for (PTransformOverride override : overrides) {
            this.replace(override);
        }
        this.checkNoMoreMatches(overrides);
    }

    private void checkNoMoreMatches(final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PTransformOverride> overrides) {
        this.traverseTopologically(new PipelineVisitor.Defaults(){
            @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node, @UnknownKeyFor @NonNull @Initialized PTransformOverride> matched = HashMultimap.create();

            @Override
            public @UnknownKeyFor @NonNull @Initialized PipelineVisitor.CompositeBehavior enterCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (!node.isRootNode()) {
                    this.checkForMatches(node);
                }
                if (this.matched.containsKey((Object)node)) {
                    return PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
                }
                return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void leaveCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (node.isRootNode() && !this.matched.isEmpty()) {
                    LOG.info("Found nodes that matched overrides. Matches: {}. The match usually should be empty unless there are runner specific replacement transforms.", this.matched);
                }
            }

            @Override
            public void visitPrimitiveTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.checkForMatches(node);
            }

            private void checkForMatches(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                for (PTransformOverride override : overrides) {
                    if (!override.getMatcher().matchesDuringValidation(node.toAppliedPTransform(this.getPipeline()))) continue;
                    this.matched.put((Object)node, (Object)override);
                }
            }
        });
    }

    private void replace(final @UnknownKeyFor @NonNull @Initialized PTransformOverride override) {
        final HashSet matches = new HashSet();
        final HashSet freedNodes = new HashSet();
        this.traverseTopologically(new PipelineVisitor.Defaults(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PipelineVisitor.CompositeBehavior enterCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (!node.isRootNode() && freedNodes.contains(node.getEnclosingNode())) {
                    freedNodes.add(node);
                    return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
                }
                if (!node.isRootNode() && override.getMatcher().matches(node.toAppliedPTransform(this.getPipeline()))) {
                    matches.add(node);
                    freedNodes.add(node);
                }
                return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void visitPrimitiveTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (freedNodes.contains(node.getEnclosingNode())) {
                    freedNodes.add(node);
                } else if (override.getMatcher().matches(node.toAppliedPTransform(this.getPipeline()))) {
                    matches.add(node);
                    freedNodes.add(node);
                }
            }
        });
        for (TransformHierarchy.Node freedNode : freedNodes) {
            this.usedFullNames.remove(freedNode.getFullName());
        }
        for (TransformHierarchy.Node match : matches) {
            this.applyReplacement(match, override.getOverrideFactory());
        }
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run() {
        return this.run(this.defaultOptions);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        PipelineRunner<PipelineResult> runner = PipelineRunner.fromOptions(options);
        LOG.debug("Running {} via {}", (Object)this, runner);
        try {
            this.validate(options);
            this.validateErrorHandlers();
            return runner.run(this);
        }
        catch (UserCodeException e) {
            throw new PipelineExecutionException(e.getCause());
        }
    }

    public @UnknownKeyFor @NonNull @Initialized CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = CoderRegistry.createDefault();
        }
        return this.coderRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaRegistry getSchemaRegistry() {
        if (this.schemaRegistry == null) {
            this.schemaRegistry = SchemaRegistry.createDefault();
        }
        return this.schemaRegistry;
    }

    public <OutputT extends POutput> @UnknownKeyFor @NonNull @Initialized ErrorHandler.BadRecordErrorHandler<OutputT> registerBadRecordErrorHandler(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BadRecord>, OutputT> sinkTransform) {
        ErrorHandler.BadRecordErrorHandler<OutputT> errorHandler = new ErrorHandler.BadRecordErrorHandler<OutputT>(sinkTransform, this);
        this.errorHandlers.add(errorHandler);
        return errorHandler;
    }

    @Deprecated
    public void setCoderRegistry(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
        this.coderRegistry = coderRegistry;
    }

    @Internal
    public void traverseTopologically(@UnknownKeyFor @NonNull @Initialized PipelineVisitor visitor) {
        visitor.enterPipeline(this);
        this.transforms.visit(visitor);
        visitor.leavePipeline(this);
    }

    @Internal
    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(InputT input, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(transform.getName(), input, transform);
    }

    @Internal
    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(@UnknownKeyFor @NonNull @Initialized String name, InputT input, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(name, input, transform);
    }

    private Pipeline(@UnknownKeyFor @NonNull @Initialized TransformHierarchy transforms, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        CoderTranslation.verifyModelCodersRegistered();
        this.transforms = transforms;
        this.defaultOptions = options;
    }

    protected Pipeline(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this(new TransformHierarchy(ResourceHints.fromOptions(options)), options);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Pipeline#" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InputT extends PInput, OutputT extends POutput> OutputT applyInternal(@UnknownKeyFor @NonNull @Initialized String name, InputT input, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super InputT, OutputT> transform) {
        String namePrefix = this.transforms.getCurrent().getFullName();
        String uniqueName = this.uniquifyInternal(namePrefix, name);
        String builtName = this.buildName(namePrefix, name);
        this.instancePerName.put((Object)builtName, transform);
        LOG.debug("Adding {} to {}", transform, (Object)this);
        this.transforms.pushNode(uniqueName, input, transform);
        try {
            this.transforms.finishSpecifyingInput();
            OutputT output = transform.expand(input);
            this.transforms.setOutput((POutput)output);
            OutputT OutputT = output;
            return OutputT;
        }
        finally {
            this.transforms.popNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InputT extends PInput, OutputT extends POutput, TransformT extends PTransform<? super InputT, OutputT>> void applyReplacement(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node original, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory<InputT, OutputT, TransformT> replacementFactory) {
        PTransformOverrideFactory.PTransformReplacement<InputT, OutputT> replacement = replacementFactory.getReplacementTransform(original.toAppliedPTransform(this));
        if (replacement.getTransform() == original.getTransform()) {
            return;
        }
        InputT originalInput = replacement.getInput();
        Map<TupleTag<?>, PCollection<?>> originalOutputs = original.getOutputs();
        LOG.debug("Replacing {} with {}", (Object)original, replacement);
        this.transforms.replaceNode(original, (PInput)originalInput, replacement.getTransform());
        try {
            OutputT newOutput = replacement.getTransform().expand(originalInput);
            Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> originalToReplacement = replacementFactory.mapOutputs(original.getOutputs(), newOutput);
            this.transforms.setOutput((POutput)newOutput);
            this.transforms.replaceOutputs(originalToReplacement);
            Preconditions.checkState((boolean)ImmutableSet.copyOf(originalOutputs.values()).equals((Object)ImmutableSet.copyOf(this.transforms.getCurrent().getOutputs().values())), (String)"After replacing %s with %s, outputs were not rewired correctly: Original outputs %s became %s.", (Object)original, (Object)this.transforms.getCurrent(), originalOutputs, this.transforms.getCurrent().getOutputs());
        }
        finally {
            this.transforms.popNode();
        }
    }

    @VisibleForTesting
    void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.traverseTopologically(new ValidateVisitor(options));
        Collection errors = Collections2.filter(this.instancePerName.asMap().entrySet(), (Predicate)Predicates.not(new IsUnique()));
        if (!errors.isEmpty()) {
            switch (options.getStableUniqueNames()) {
                case OFF: {
                    break;
                }
                case WARNING: {
                    LOG.warn("The following transforms do not have stable unique names: {}", (Object)Joiner.on((String)", ").join(Iterables.transform((Iterable)errors, (Function)new KeysExtractor())));
                    break;
                }
                case ERROR: {
                    throw new IllegalStateException(String.format("Pipeline update will not be possible because the following transforms do not have stable unique names: %s.", Joiner.on((String)", ").join(Iterables.transform((Iterable)errors, (Function)new KeysExtractor()))) + "\n\nConflicting instances:\n" + Joiner.on((String)"\n").join(Iterables.transform((Iterable)errors, (Function)new UnstableNameToMessage(this.instancePerName))) + "\n\nYou can fix it adding a name when you call apply(): pipeline.apply(<name>, <transform>).");
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized value for stable unique names: " + (Object)((Object)options.getStableUniqueNames()));
                }
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String uniquifyInternal(@UnknownKeyFor @NonNull @Initialized String namePrefix, @UnknownKeyFor @NonNull @Initialized String origName) {
        String name = origName;
        int suffixNum = 2;
        String candidate;
        while (!this.usedFullNames.add(candidate = this.buildName(namePrefix, name))) {
            name = origName + suffixNum++;
        }
        return candidate;
    }

    private @UnknownKeyFor @NonNull @Initialized String buildName(@UnknownKeyFor @NonNull @Initialized String namePrefix, @UnknownKeyFor @NonNull @Initialized String name) {
        return namePrefix.isEmpty() ? name : namePrefix + "/" + name;
    }

    private void validateErrorHandlers() {
        for (ErrorHandler<?, ?> errorHandler : this.errorHandlers) {
            if (errorHandler.isClosed()) continue;
            throw new IllegalStateException("One or more ErrorHandlers aren't closed, and this pipeline cannot be run. See the ErrorHandler documentation for expected usage");
        }
    }

    private static class IsUnique<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Predicate<Map.Entry<K, Collection<V>>> {
        private IsUnique() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized boolean apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Map.Entry<K, @UnknownKeyFor @NonNull @Initialized Collection<V>> input) {
            return input != null && input.getValue().size() == 1;
        }
    }

    private static class KeysExtractor
    implements Function<Map.Entry<String, Collection<PTransform<?, ?>>>, String> {
        private KeysExtractor() {
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized String apply(@Nonnull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> input) {
            return input.getKey();
        }
    }

    private static class UnstableNameToMessage
    implements Function<Map.Entry<String, Collection<PTransform<?, ?>>>, String> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> instances;

        private UnstableNameToMessage(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> instancePerName) {
            this.instances = instancePerName;
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized String apply(@Nonnull /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> input) {
            Collection values = this.instances.get((Object)input.getKey());
            return "- name=" + input.getKey() + ":\n" + Joiner.on((String)"\n").join(Iterables.transform((Iterable)values, (Function)new TransformToMessage()));
        }
    }

    private static class TransformToMessage
    implements Function<PTransform<?, ?>, String> {
        private TransformToMessage() {
        }

        public @UnknownKeyFor @NonNull @Initialized String apply(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            return "    - " + transform;
        }
    }

    private static class ValidateVisitor
    extends PipelineVisitor.Defaults {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;

        public ValidateVisitor(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.options = options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineVisitor.CompositeBehavior enterCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.getTransform() != null) {
                node.getTransform().validate(this.options, node.getInputs(), node.getOutputs());
            }
            return PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void visitPrimitiveTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            node.getTransform().validate(this.options, node.getInputs(), node.getOutputs());
        }
    }

    @Internal
    public static interface PipelineVisitor {
        public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline var1);

        public @UnknownKeyFor @NonNull @Initialized CompositeBehavior enterCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);

        public void leaveCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);

        public void visitPrimitiveTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1);

        public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue var1, @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var2);

        public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline var1);

        public static class Defaults
        implements PipelineVisitor {
            private @Nullable @UnknownKeyFor @Initialized Pipeline pipeline;

            protected @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                if (this.pipeline == null) {
                    throw new IllegalStateException("Illegal access to pipeline after visitor traversal was completed");
                }
                return this.pipeline;
            }

            @Override
            public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
                this.pipeline = (Pipeline)Preconditions.checkNotNull((Object)pipeline);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized CompositeBehavior enterCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                return CompositeBehavior.ENTER_TRANSFORM;
            }

            @Override
            public void leaveCompositeTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            }

            @Override
            public void visitPrimitiveTransform(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            }

            @Override
            public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
            }

            @Override
            public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
                this.pipeline = null;
            }
        }

        public static enum CompositeBehavior {
            ENTER_TRANSFORM,
            DO_NOT_ENTER_TRANSFORM;

        }
    }

    public static class PipelineExecutionException
    extends RuntimeException {
        public PipelineExecutionException(@UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super(cause);
        }
    }
}

