/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.UnsafeByteOperations;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@NotThreadSafe
public final class ByteStringOutputStream
extends OutputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CAPACITY = 128;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_CHUNK_SIZE = 262144;
    private @UnknownKeyFor @NonNull @Initialized ByteString result;
    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer;
    private @UnknownKeyFor @NonNull @Initialized int bufferPos;

    public ByteStringOutputStream() {
        this(128);
    }

    public ByteStringOutputStream(@UnknownKeyFor @NonNull @Initialized int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity < 0");
        }
        this.buffer = new byte[initialCapacity];
        this.result = ByteString.EMPTY;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int b) {
        if (this.bufferPos == this.buffer.length) {
            this.result = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer));
            this.buffer = new byte[Math.min(Math.max(1, this.result.size()), 262144)];
            this.bufferPos = 0;
        }
        this.buffer[this.bufferPos++] = (byte)b;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) {
        int remainingSpaceInBuffer = this.buffer.length - this.bufferPos;
        while (length > remainingSpaceInBuffer) {
            System.arraycopy(b, offset, this.buffer, this.bufferPos, remainingSpaceInBuffer);
            offset += remainingSpaceInBuffer;
            this.result = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer));
            remainingSpaceInBuffer = Math.min(Math.max(length -= remainingSpaceInBuffer, this.result.size()), 262144);
            this.buffer = new byte[remainingSpaceInBuffer];
            this.bufferPos = 0;
        }
        System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
        this.bufferPos += length;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString toByteString() {
        return this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)0, (int)this.bufferPos));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean shouldCopy(@UnknownKeyFor @NonNull @Initialized int bufferLength, @UnknownKeyFor @NonNull @Initialized int bytesToCopy) {
        if (bufferLength <= 128) {
            return true;
        }
        if (bufferLength <= 1024) {
            return (double)bytesToCopy <= (double)bufferLength * 0.875;
        }
        if (bufferLength <= 8192) {
            return (double)bytesToCopy <= (double)bufferLength * 0.75;
        }
        return (double)bytesToCopy <= (double)bufferLength * 0.4375;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString toByteStringAndReset() {
        ByteString rval;
        if (this.bufferPos > 0) {
            boolean copy = ByteStringOutputStream.shouldCopy(this.buffer.length, this.bufferPos);
            if (copy) {
                rval = this.result.concat(ByteString.copyFrom((byte[])this.buffer, (int)0, (int)this.bufferPos));
            } else {
                rval = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)0, (int)this.bufferPos));
                this.buffer = new byte[Math.min(rval.size(), 262144)];
            }
            this.bufferPos = 0;
        } else {
            rval = this.result;
        }
        this.result = ByteString.EMPTY;
        return rval;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString consumePrefixToByteString(@UnknownKeyFor @NonNull @Initialized int prefixSize) {
        Preconditions.checkArgument((prefixSize <= this.size() ? 1 : 0) != 0);
        if (prefixSize == this.size()) {
            return this.toByteStringAndReset();
        }
        int bytesFromBuffer = prefixSize - this.result.size();
        if (bytesFromBuffer == 0) {
            ByteString rval = this.result;
            this.result = ByteString.EMPTY;
            return rval;
        }
        if (bytesFromBuffer < 0) {
            ByteString rval = this.result.substring(0, prefixSize);
            this.result = this.result.substring(prefixSize);
            return rval;
        }
        ByteString rval = ByteStringOutputStream.shouldCopy(this.buffer.length, bytesFromBuffer) ? this.result.concat(ByteString.copyFrom((byte[])this.buffer, (int)0, (int)bytesFromBuffer)) : this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)0, (int)bytesFromBuffer));
        int remainingBytes = this.bufferPos - bytesFromBuffer;
        this.result = ByteStringOutputStream.shouldCopy(this.buffer.length, remainingBytes) ? ByteString.copyFrom((byte[])this.buffer, (int)bytesFromBuffer, (int)remainingBytes) : UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)bytesFromBuffer, (int)remainingBytes);
        this.buffer = new byte[Math.min(Math.max(1, this.buffer.length), 262144)];
        this.bufferPos = 0;
        return rval;
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.result.size() + this.bufferPos;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("<ByteStringOutputStream@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }
}

