/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.Request;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.RequestProcessor;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.txn.ErrorTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderRequestProcessor.class);
    private final LeaderZooKeeperServer lzks;
    private final RequestProcessor nextProcessor;

    public LeaderRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.lzks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        if (!this.lzks.authWriteRequest(request)) {
            return;
        }
        Request upgradeRequest = null;
        try {
            upgradeRequest = this.lzks.checkUpgradeSession(request);
        }
        catch (KeeperException ke) {
            if (request.getHdr() != null) {
                LOG.debug("Updating header");
                request.getHdr().setType(-1);
                request.setTxn(new ErrorTxn(ke.code().intValue()));
            }
            request.setException(ke);
            LOG.warn("Error creating upgrade request", (Throwable)ke);
        }
        catch (IOException ie) {
            LOG.error("Unexpected error in upgrade", (Throwable)ie);
        }
        if (upgradeRequest != null) {
            this.nextProcessor.processRequest(upgradeRequest);
        }
        this.nextProcessor.processRequest(request);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.nextProcessor.shutdown();
    }
}

