/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.update;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.update.UpdateData;
import org.apache.hop.pipeline.transforms.update.UpdateField;
import org.apache.hop.pipeline.transforms.update.UpdateKeyField;
import org.apache.hop.pipeline.transforms.update.UpdateMeta;

public class Update
extends BaseTransform<UpdateMeta, UpdateData> {
    private static final Class<?> PKG = UpdateMeta.class;
    public static final String CONST_IS_NULL = "IS NULL";
    public static final String CONST_UPDATE_EXCEPTION_FIELD_REQUIRED = "Update.Exception.FieldRequired";
    public static final String CONST_IS_NOT_NULL = "IS NOT NULL";
    public static final String CONST_NULL = "= ~NULL";
    public static final String CONST_BETWEEN = "BETWEEN";

    public Update(TransformMeta transformMeta, UpdateMeta meta, UpdateData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] add;
        Object[] outputRow = row;
        if (!Utils.isEmpty((CharSequence)((UpdateMeta)this.meta).getIgnoreFlagField())) {
            outputRow = new Object[((UpdateData)this.data).outputRowMeta.size()];
            for (int i = 0; i < rowMeta.size(); ++i) {
                outputRow[i] = row[i];
            }
        }
        Object[] lookupRow = new Object[((UpdateData)this.data).lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < ((UpdateData)this.data).keynrs.length; ++i) {
            if (((UpdateData)this.data).keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[((UpdateData)this.data).keynrs[i]];
                ++lookupIndex;
            }
            if (((UpdateData)this.data).keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[((UpdateData)this.data).keynrs2[i]];
            ++lookupIndex;
        }
        IRowMeta returnRowMeta = null;
        if (!((UpdateMeta)this.meta).isSkipLookup()) {
            ((UpdateData)this.data).db.setValues(((UpdateData)this.data).lookupParameterRowMeta, lookupRow, ((UpdateData)this.data).prepStatementLookup);
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.ValuesSetForLookup", (String[])new String[]{((UpdateData)this.data).lookupParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
            }
            add = ((UpdateData)this.data).db.getLookup(((UpdateData)this.data).prepStatementLookup);
            returnRowMeta = ((UpdateData)this.data).db.getReturnRowMeta();
        } else {
            add = null;
        }
        this.incrementLinesInput();
        if (add == null && !((UpdateMeta)this.meta).isSkipLookup()) {
            if (!((UpdateMeta)this.meta).isErrorIgnored()) {
                if (!this.getTransformMeta().isDoingErrorHandling()) throw new HopDatabaseException(BaseMessages.getString(PKG, (String)"Update.Exception.KeyCouldNotFound", (String[])new String[0]) + ((UpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
                outputRow = null;
                if (((UpdateData)this.data).stringErrorKeyNotFound == null) {
                    ((UpdateData)this.data).stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"Update.Exception.KeyCouldNotFound", (String[])new String[0]) + ((UpdateData)this.data).lookupParameterRowMeta.getString(lookupRow);
                    ((UpdateData)this.data).stringFieldnames = "";
                    for (int i = 0; i < ((UpdateData)this.data).lookupParameterRowMeta.size(); ++i) {
                        if (i > 0) {
                            ((UpdateData)this.data).stringFieldnames = ((UpdateData)this.data).stringFieldnames + ", ";
                        }
                        ((UpdateData)this.data).stringFieldnames = ((UpdateData)this.data).stringFieldnames + ((UpdateData)this.data).lookupParameterRowMeta.getValueMeta(i).getName();
                    }
                }
                this.putError(rowMeta, row, 1L, ((UpdateData)this.data).stringErrorKeyNotFound, ((UpdateData)this.data).stringFieldnames, "UPD001");
                return outputRow;
            } else {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.KeyCouldNotFound", (String[])new String[0]) + ((UpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
                }
                if (Utils.isEmpty((CharSequence)((UpdateMeta)this.meta).getIgnoreFlagField())) return outputRow;
                outputRow[rowMeta.size()] = Boolean.FALSE;
            }
            return outputRow;
        } else {
            if (!((UpdateMeta)this.meta).isSkipLookup() && this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"Update.Log.FoundRow", (String[])new String[0]) + ((UpdateData)this.data).lookupReturnRowMeta.getString(add));
            }
            boolean update = false;
            if (((UpdateMeta)this.meta).isSkipLookup()) {
                update = true;
            } else {
                for (int i = 0; i < ((UpdateData)this.data).valuenrs.length; ++i) {
                    Object retvalue;
                    IValueMeta valueMeta = rowMeta.getValueMeta(((UpdateData)this.data).valuenrs[i]);
                    Object rowvalue = row[((UpdateData)this.data).valuenrs[i]];
                    IValueMeta returnValueMeta = returnRowMeta.getValueMeta(i);
                    if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                    update = true;
                }
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[((UpdateData)this.data).updateParameterRowMeta.size()];
                for (i = 0; i < ((UpdateData)this.data).valuenrs.length; ++i) {
                    updateRow[i] = row[((UpdateData)this.data).valuenrs[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[((UpdateData)this.data).valuenrs.length + i] = lookupRow[i];
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Update.Log.UpdateRow", (String[])new String[0]) + ((UpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
                }
                ((UpdateData)this.data).db.setValues(((UpdateData)this.data).updateParameterRowMeta, updateRow, ((UpdateData)this.data).prepStatementUpdate);
                ((UpdateData)this.data).db.insertRow(((UpdateData)this.data).prepStatementUpdate, ((UpdateMeta)this.meta).isUseBatchUpdate(), true);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
            if (Utils.isEmpty((CharSequence)((UpdateMeta)this.meta).getIgnoreFlagField())) return outputRow;
            outputRow[rowMeta.size()] = Boolean.TRUE;
        }
        return outputRow;
    }

    public boolean processRow() throws HopException {
        block19: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                UpdateKeyField keyItem;
                int i;
                this.first = false;
                ((UpdateData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((UpdateMeta)this.meta).getFields(((UpdateData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((UpdateMeta)this.meta).getConnection(), this.variables);
                ((UpdateData)this.data).schemaTable = databaseMeta.getQuotedSchemaTableCombination((IVariables)this, ((UpdateMeta)this.meta).getLookupField().getSchemaName(), ((UpdateMeta)this.meta).getLookupField().getTableName());
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                ArrayList<Integer> keynrs = new ArrayList<Integer>(((UpdateMeta)this.meta).getLookupField().getLookupKeys().size());
                ArrayList<Integer> keynrs2 = new ArrayList<Integer>(((UpdateMeta)this.meta).getLookupField().getLookupKeys().size());
                for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getLookupKeys().size(); ++i) {
                    int keynr2;
                    keyItem = ((UpdateMeta)this.meta).getLookupField().getLookupKeys().get(i);
                    int keynr = this.getInputRowMeta().indexOfValue(keyItem.getKeyStream());
                    if (keynr < 0 && !CONST_IS_NULL.equalsIgnoreCase(keyItem.getKeyCondition()) && !CONST_IS_NOT_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{keyItem.getKeyStream()}));
                    }
                    keynrs.add(keynr);
                    if (CONST_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                        keynrs.add(keynr);
                        keynrs2.add(-1);
                    }
                    if ((keynr2 = this.getInputRowMeta().indexOfValue(keyItem.getKeyStream2())) < 0 && CONST_BETWEEN.equalsIgnoreCase(keyItem.getKeyCondition())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{keyItem.getKeyStream2()}));
                    }
                    keynrs2.add(keynr2);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.FieldHasDataNumbers", (String[])new String[]{keyItem.getKeyStream()}) + String.valueOf(keynrs.get(keynrs.size() - 1)));
                }
                ((UpdateData)this.data).keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
                ((UpdateData)this.data).keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
                ((UpdateData)this.data).valuenrs = new int[((UpdateMeta)this.meta).getLookupField().getUpdateFields().size()];
                for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getUpdateFields().size(); ++i) {
                    UpdateField fieldItem = ((UpdateMeta)this.meta).getLookupField().getUpdateFields().get(i);
                    ((UpdateData)this.data).valuenrs[i] = this.getInputRowMeta().indexOfValue(fieldItem.getUpdateStream());
                    if (((UpdateData)this.data).valuenrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_UPDATE_EXCEPTION_FIELD_REQUIRED, (String[])new String[]{fieldItem.getUpdateStream()}));
                    }
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.FieldHasDataNumbers", (String[])new String[]{fieldItem.getUpdateStream()}) + ((UpdateData)this.data).valuenrs[i]);
                }
                if (((UpdateMeta)this.meta).isSkipLookup()) {
                    ((UpdateData)this.data).lookupParameterRowMeta = new RowMeta();
                    for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getLookupKeys().size(); ++i) {
                        keyItem = ((UpdateMeta)this.meta).getLookupField().getLookupKeys().get(i);
                        if (CONST_BETWEEN.equalsIgnoreCase(keyItem.getKeyCondition())) {
                            ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(keyItem.getKeyStream()));
                            ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(keyItem.getKeyStream2()));
                            continue;
                        }
                        if (CONST_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                            ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(keyItem.getKeyStream()));
                            ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(keyItem.getKeyStream()).clone());
                            continue;
                        }
                        if (CONST_IS_NULL.equalsIgnoreCase(keyItem.getKeyCondition()) || CONST_IS_NOT_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) continue;
                        ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(keyItem.getKeyStream()));
                    }
                } else {
                    this.setLookup(this.getInputRowMeta());
                }
                this.prepareUpdate(this.getInputRowMeta());
            }
            try {
                Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
                if (outputRow != null) {
                    this.putRow(((UpdateData)this.data).outputRowMeta, outputRow);
                }
                if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"Update.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Update.Log.ErrorInTransform", (String[])new String[0]), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "UPD001");
            }
        }
        return true;
    }

    public void setLookup(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        ((UpdateData)this.data).lookupParameterRowMeta = new RowMeta();
        ((UpdateData)this.data).lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((UpdateMeta)this.meta).getConnection(), this.variables);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getUpdateFields().size(); ++i) {
            UpdateField fieldItem = ((UpdateMeta)this.meta).getLookupField().getUpdateFields().get(i);
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(databaseMeta.quoteField(fieldItem.getUpdateLookup()));
            ((UpdateData)this.data).lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(fieldItem.getUpdateStream()));
        }
        sql.append(" FROM " + ((UpdateData)this.data).schemaTable + " WHERE ");
        for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getLookupKeys().size(); ++i) {
            UpdateKeyField keyItem = ((UpdateMeta)this.meta).getLookupField().getLookupKeys().get(i);
            if (i != 0) {
                sql.append(" AND ");
            }
            sql.append(" ( ( ");
            sql.append(databaseMeta.quoteField(keyItem.getKeyLookup()));
            if (CONST_BETWEEN.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" BETWEEN ? AND ? ");
                ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
                ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream2()));
            } else if (CONST_IS_NULL.equalsIgnoreCase(keyItem.getKeyCondition()) || CONST_IS_NOT_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" ").append(keyItem.getKeyCondition()).append(" ");
            } else if (CONST_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" IS NULL AND ");
                if (databaseMeta.requiresCastToVariousForIsNull()) {
                    sql.append("CAST(? AS VARCHAR(256)) IS NULL");
                } else {
                    sql.append("? IS NULL");
                }
                ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
                sql.append(" ) OR ( ").append(databaseMeta.quoteField(keyItem.getKeyLookup())).append(" = ?");
                ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()).clone());
            } else {
                sql.append(" ").append(keyItem.getKeyCondition()).append(" ? ");
                ((UpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
            }
            sql.append(" ) ) ");
        }
        try {
            if (this.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + String.valueOf(sql) + "]");
            }
            ((UpdateData)this.data).prepStatementLookup = ((UpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + String.valueOf(sql) + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((UpdateMeta)this.meta).getConnection(), this.variables);
        ((UpdateData)this.data).updateParameterRowMeta = new RowMeta();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(((UpdateData)this.data).schemaTable).append(Const.CR);
        sql.append("SET ");
        for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getUpdateFields().size(); ++i) {
            UpdateField fieldItem = ((UpdateMeta)this.meta).getLookupField().getUpdateFields().get(i);
            if (i != 0) {
                sql.append(",   ");
            }
            sql.append(databaseMeta.quoteField(fieldItem.getUpdateLookup()));
            sql.append(" = ?").append(Const.CR);
            ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(fieldItem.getUpdateStream()));
        }
        sql.append("WHERE ");
        for (i = 0; i < ((UpdateMeta)this.meta).getLookupField().getLookupKeys().size(); ++i) {
            UpdateKeyField keyItem = ((UpdateMeta)this.meta).getLookupField().getLookupKeys().get(i);
            if (i != 0) {
                sql.append("AND   ");
            }
            sql.append(" ( ( ");
            sql.append(databaseMeta.quoteField(keyItem.getKeyLookup()));
            if (CONST_BETWEEN.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" BETWEEN ? AND ? ");
                ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
                ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream2()));
            } else if (CONST_IS_NULL.equalsIgnoreCase(keyItem.getKeyCondition()) || CONST_IS_NOT_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" ").append(keyItem.getKeyCondition()).append(" ");
            } else if (CONST_NULL.equalsIgnoreCase(keyItem.getKeyCondition())) {
                sql.append(" IS NULL AND ");
                if (databaseMeta.requiresCastToVariousForIsNull()) {
                    sql.append("CAST(? AS VARCHAR(256)) IS NULL");
                } else {
                    sql.append("? IS NULL");
                }
                ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
                sql.append(" ) OR ( ").append(databaseMeta.quoteField(keyItem.getKeyLookup())).append(" = ?");
                ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()).clone());
            } else {
                sql.append(" ").append(keyItem.getKeyCondition()).append(" ? ");
                ((UpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(keyItem.getKeyStream()));
            }
            sql.append(" ) ) ");
        }
        try {
            if (this.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + String.valueOf(sql) + "]");
            }
            ((UpdateData)this.data).prepStatementUpdate = ((UpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + String.valueOf(sql) + "]", (Throwable)ex);
        }
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((UpdateMeta)this.meta).getConnection())) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((UpdateMeta)this.meta).getConnection(), this.variables);
            ((UpdateData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
            try {
                ((UpdateData)this.data).db.connect();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.ConnectedToDB", (String[])new String[0]));
                }
                ((UpdateData)this.data).db.setCommit(((UpdateMeta)this.meta).getCommitSize((IVariables)this));
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void batchComplete() throws HopException {
        this.commitBatch(false);
    }

    public void dispose() {
        this.commitBatch(true);
        super.dispose();
    }

    private void commitBatch(boolean dispose) {
        if (((UpdateData)this.data).db != null) {
            try {
                if (!((UpdateData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        if (dispose) {
                            ((UpdateData)this.data).db.emptyAndCommit(((UpdateData)this.data).prepStatementUpdate, ((UpdateMeta)this.meta).isUseBatchUpdate());
                            ((UpdateData)this.data).prepStatementUpdate = null;
                        } else {
                            ((UpdateData)this.data).db.commit();
                        }
                    } else {
                        ((UpdateData)this.data).db.rollback();
                    }
                }
                if (dispose) {
                    if (((UpdateData)this.data).prepStatementLookup != null) {
                        ((UpdateData)this.data).db.closePreparedStatement(((UpdateData)this.data).prepStatementLookup);
                    }
                    ((UpdateData)this.data).prepStatementLookup = null;
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(((UpdateData)this.data).db) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                if (dispose) {
                    ((UpdateData)this.data).db.disconnect();
                    ((UpdateData)this.data).db = null;
                }
            }
        }
    }
}

