/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffers;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpConnection;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.log.Log;

class SocketConnector
extends AbstractLifeCycle
implements HttpClient.Connector {
    private final HttpClient _httpClient;

    SocketConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public void startConnection(final HttpDestination destination) throws IOException {
        Socket socket = null;
        if (destination.isSecure()) {
            SSLContext sslContext = this._httpClient.getSSLContext();
            socket = sslContext.getSocketFactory().createSocket();
        } else {
            Log.debug((String)"Using Regular Socket");
            socket = SocketFactory.getDefault().createSocket();
        }
        socket.setSoTimeout(this._httpClient.getSoTimeout());
        socket.setTcpNoDelay(true);
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        socket.connect(address.toSocketAddress());
        SocketEndPoint endpoint = new SocketEndPoint(socket);
        final HttpConnection connection = new HttpConnection((Buffers)this._httpClient, (EndPoint)endpoint, this._httpClient.getHeaderBufferSize(), this._httpClient.getRequestBufferSize());
        connection.setDestination(destination);
        destination.onNewConnection(connection);
        this._httpClient.getThreadPool().dispatch(new Runnable(){

            public void run() {
                try {
                    connection.handle();
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        Log.ignore((Throwable)e);
                    }
                    Log.warn((Throwable)e);
                    destination.onException(e);
                }
            }
        });
    }
}

