/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Arrays;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.kafka.common.header.Headers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class KafkaRecord<@UnknownKeyFor K, @UnknownKeyFor V> {
    private final @UnknownKeyFor @NonNull @Initialized String topic;
    private final @UnknownKeyFor @NonNull @Initialized int partition;
    private final @UnknownKeyFor @NonNull @Initialized long offset;
    private final @Nullable @UnknownKeyFor @Initialized Headers headers;
    private final @UnknownKeyFor @NonNull @Initialized KV<K, V> kv;
    private final @UnknownKeyFor @NonNull @Initialized long timestamp;
    private final @UnknownKeyFor @NonNull @Initialized KafkaTimestampType timestampType;

    public KafkaRecord(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partition, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized KafkaTimestampType timestampType, @Nullable @UnknownKeyFor @Initialized Headers headers, K key, V value) {
        this(topic, partition, offset, timestamp, timestampType, headers, KV.of(key, value));
    }

    public KafkaRecord(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized int partition, @UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized long timestamp, @UnknownKeyFor @NonNull @Initialized KafkaTimestampType timestampType, @Nullable @UnknownKeyFor @Initialized Headers headers, @UnknownKeyFor @NonNull @Initialized KV<K, V> kv) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.timestampType = timestampType;
        this.headers = headers;
        this.kv = kv;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTopic() {
        return this.topic;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPartition() {
        return this.partition;
    }

    public @UnknownKeyFor @NonNull @Initialized long getOffset() {
        return this.offset;
    }

    @Pure
    public @Nullable @UnknownKeyFor @Initialized Headers getHeaders() {
        if (!ConsumerSpEL.hasHeaders()) {
            throw new RuntimeException("The version kafka-clients does not support record headers, please use version 0.11.0.0 or newer");
        }
        return this.headers;
    }

    public @UnknownKeyFor @NonNull @Initialized KV<K, V> getKV() {
        return this.kv;
    }

    public @UnknownKeyFor @NonNull @Initialized long getTimestamp() {
        return this.timestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized KafkaTimestampType getTimestampType() {
        return this.timestampType;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.topic, this.partition, this.offset, this.timestamp, this.headers, this.kv});
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (obj instanceof KafkaRecord) {
            KafkaRecord other = (KafkaRecord)obj;
            return this.topic.equals(other.topic) && this.partition == other.partition && this.offset == other.offset && this.timestamp == other.timestamp && Objects.equal((Object)this.headers, (Object)other.headers) && this.kv.equals(other.kv);
        }
        return false;
    }
}

