/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.runners.core.metrics.DistributionCell;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CheckpointStats {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> checkpointDurations = new HashMap<Long, Long>();
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized DistributionCell> distributionCellSupplier;

    public CheckpointStats(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized DistributionCell> distributionCellSupplier) {
        this.distributionCellSupplier = distributionCellSupplier;
    }

    public void snapshotStart(@UnknownKeyFor @NonNull @Initialized long checkpointId) {
        this.checkpointDurations.put(checkpointId, System.currentTimeMillis());
    }

    public void reportCheckpointDuration(@UnknownKeyFor @NonNull @Initialized long checkpointId) {
        Long checkpointStart = this.checkpointDurations.remove(checkpointId);
        if (checkpointStart != null) {
            long checkpointDuration = System.currentTimeMillis() - checkpointStart;
            this.distributionCellSupplier.get().update(checkpointDuration);
        }
    }
}

