/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CommandList
implements Serializable {
    static final long serialVersionUID = 6L;
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/CMDLST.USRSPC";
    public static final String ALL = "*ALL";
    private AS400 sys_;
    private String lib_;
    private String cmd_;
    private static final ProgramParameter parm0_ = new ProgramParameter(new byte[]{-61, -44, -60, -45, -30, -29, 64, 64, 64, 64, -40, -29, -59, -44, -41, 64, 64, 64, 64, 64, 64});
    private static final ProgramParameter parm1_ = new ProgramParameter(new byte[]{-42, -62, -47, -45, -16, -14, -16, -16});
    private static final ProgramParameter parm3_ = new ProgramParameter(new byte[]{92, -61, -44, -60, 64, 64, 64, 64, 64, 64});
    private static final ProgramParameter parm4_ = new ProgramParameter(new byte[4]);
    private transient PropertyChangeSupport propertyChangeListeners_ = new PropertyChangeSupport(this);

    public CommandList() {
        this.initializeTransient();
    }

    public CommandList(AS400 system, String library, String command) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.sys_ = system;
        this.lib_ = library;
        this.cmd_ = command;
        this.initializeTransient();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    public String getCommand() {
        return this.cmd_;
    }

    public String getLibrary() {
        return this.lib_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Command[] generateList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Generating list of commands using library filter '" + this.lib_ + "' and command filter '" + this.cmd_ + "'.");
        }
        if (this.sys_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.lib_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        if (this.cmd_ == null) {
            throw new ExtendedIllegalStateException("command", 4);
        }
        CharConverter conv37_ = new CharConverter(37);
        StringBuffer commandString = new StringBuffer(this.cmd_.toUpperCase().trim());
        while (commandString.length() < 10) {
            commandString.append(' ');
        }
        StringBuffer libraryString = new StringBuffer(this.lib_.toUpperCase().trim());
        while (libraryString.length() < 10) {
            libraryString.append(' ');
        }
        ProgramParameter[] parms = new ProgramParameter[]{parm0_, parm1_, new ProgramParameter(conv37_.stringToByteArray(commandString.toString() + libraryString.toString())), parm3_, parm4_};
        CharConverter textConv = new CharConverter(this.sys_.getCcsid());
        ProgramCall pgm = new ProgramCall(this.sys_, "/QSYS.LIB/QUSLOBJ.PGM", parms);
        pgm.suggestThreadsafe();
        boolean willRunProgramsOnThread = pgm.isStayOnThread();
        Object lockObject = willRunProgramsOnThread ? USERSPACE_PATH : this.sys_;
        byte[] bytes = new byte[140];
        int offsetOfList = 0;
        int numberOfListEntries = 0;
        int sizeOfListEntry = 0;
        Object object = lockObject;
        synchronized (object) {
            UserSpace us = new UserSpace(this.sys_, USERSPACE_PATH);
            us.setMustUseProgramCall(true);
            if (!willRunProgramsOnThread) {
                us.setMustUseSockets(true);
            }
            try {
                us.create(140, true, " ", (byte)0, "", ALL);
                if (!pgm.run()) {
                    AS400Message[] messages = pgm.getMessageList();
                    throw new AS400Exception(messages);
                }
                us.read(bytes, 0, 0, 140);
                offsetOfList = BinaryConverter.byteArrayToInt(bytes, 124);
                numberOfListEntries = BinaryConverter.byteArrayToInt(bytes, 132);
                sizeOfListEntry = BinaryConverter.byteArrayToInt(bytes, 136);
                int neededSize = offsetOfList + numberOfListEntries * sizeOfListEntry;
                bytes = new byte[neededSize];
                us.read(bytes, 0, 0, neededSize);
            }
            finally {
                try {
                    us.delete();
                }
                catch (Exception e) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)e);
                }
            }
        }
        Command[] cmdList = new Command[numberOfListEntries];
        int offset = offsetOfList;
        for (int i = 0; i < numberOfListEntries; ++i) {
            String command = textConv.byteArrayToString(bytes, offset, 10).trim();
            String library = textConv.byteArrayToString(bytes, offset + 10, 10).trim();
            String desc = textConv.byteArrayToString(bytes, offset + 41, 50).trim();
            String path = QSYSObjectPathName.toPath(library, command, "CMD");
            cmdList[i] = new Command(this.sys_, path, desc);
            offset += sizeOfListEntry;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Successfully generated command list with " + numberOfListEntries + " entries.");
        }
        return cmdList;
    }

    private void initializeTransient() {
        this.propertyChangeListeners_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommand(String command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            String old = this.cmd_;
            this.cmd_ = command;
            this.propertyChangeListeners_.firePropertyChange("command", old, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLibrary(String library) {
        if (library == null) {
            throw new NullPointerException("library");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            String old = this.lib_;
            this.lib_ = library;
            this.propertyChangeListeners_.firePropertyChange("library", old, library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            AS400 old = this.sys_;
            this.sys_ = system;
            this.propertyChangeListeners_.firePropertyChange("system", old, system);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.lib_ + ";" + this.cmd_ + "]";
    }
}

