/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBSQLDADataFormat;
import java.io.UnsupportedEncodingException;

class DBReplyPackageInfo {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;
    private int length_;
    private int jobCCSID_;

    public DBReplyPackageInfo(byte[] data, int offset, int length, int jobCCSID) {
        this.data_ = data;
        this.offset_ = offset;
        this.length_ = length;
        this.jobCCSID_ = jobCCSID;
    }

    public DBDataFormat getDataFormat(int statementIndex) throws DBDataStreamException {
        int offset = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 40);
        int length = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 44);
        if (length != 6 && length != 0) {
            DBSQLDADataFormat dataFormat = new DBSQLDADataFormat(this.jobCCSID_);
            dataFormat.overlay(this.data_, this.offset_ - 6 + offset);
            return dataFormat;
        }
        return null;
    }

    public String getDefaultCollection(ConvTable converter) throws DBDataStreamException {
        return converter.byteArrayToString(this.data_, this.offset_ + 6, 18);
    }

    public int getCCSID() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 4);
    }

    private int getPackageEntryInfoOffset(int statementIndex) {
        return 42 + 64 * statementIndex;
    }

    public DBDataFormat getParameterMarkerFormat(int statementIndex) throws DBDataStreamException {
        int offset = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 56);
        int length = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 60);
        if (length != 6 && length != 0) {
            DBSQLDADataFormat parameterMarkerFormat = new DBSQLDADataFormat(this.jobCCSID_);
            parameterMarkerFormat.overlay(this.data_, this.offset_ - 6 + offset);
            return parameterMarkerFormat;
        }
        return null;
    }

    public int getStatementCount() throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 24);
    }

    public String getStatementName(int statementIndex, ConvTable converter) throws DBDataStreamException {
        try {
            return ConvTable.getTable(this.jobCCSID_, null).byteArrayToString(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 3, 18);
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    public int getStatementNeedsDefaultCollection(int statementIndex) throws DBDataStreamException {
        return this.data_[this.offset_ + this.getPackageEntryInfoOffset(statementIndex)];
    }

    public String getStatementText(int statementIndex, ConvTable converter) throws DBDataStreamException {
        int offset = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 48);
        int length = BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 52);
        return converter.byteArrayToString(this.data_, this.offset_ - 6 + offset, length);
    }

    public int getStatementTextLength(int statementIndex) throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 52);
    }

    public int getStatementType(int statementIndex) throws DBDataStreamException {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + this.getPackageEntryInfoOffset(statementIndex) + 1);
    }

    public int getTotalLength() throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_);
    }
}

