/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

class SerializableInputStream
extends InputStream
implements Serializable {
    static final long serialVersionUID = 4L;
    private byte[] byteArray_;
    private transient ByteArrayInputStream iStream_;

    public SerializableInputStream(InputStream iStream) throws IOException {
        this.byteArray_ = new byte[iStream.available()];
        int bytesRead = iStream.read(this.byteArray_);
        if (bytesRead < 1 && Trace.traceOn_) {
            Trace.log(1, "Initial read() of 'iStream' into internal buffer returned " + bytesRead);
        }
        this.iStream_ = new ByteArrayInputStream(this.byteArray_);
    }

    @Override
    public int available() throws IOException {
        return this.iStream_.available();
    }

    @Override
    public void close() throws IOException {
        this.iStream_.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.iStream_.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.iStream_.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.iStream_.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.iStream_.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.iStream_.read(b, off, len);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.iStream_ = new ByteArrayInputStream(this.byteArray_);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.iStream_.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.iStream_.skip(n);
    }
}

