/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Char;
import com.ibm.as400.util.commtrace.Formatter;

public class Data {
    private BitBuf data;
    private static final String DATA = "Data";

    Data(BitBuf data) {
        this.data = data;
    }

    public String toString() {
        BitBuf b;
        int i;
        if (this.data.getByteSize() == 0) {
            return "";
        }
        StringBuffer fmtdata = new StringBuffer(this.data.getByteSize() * 3);
        StringBuffer hexdata = new StringBuffer(32);
        StringBuffer chardata = new StringBuffer(32);
        boolean first = true;
        int length = this.data.getByteSize();
        fmtdata.append("\tData . . . . . . :  ");
        for (i = 0; i < length; ++i) {
            if (i % 32 != 0 || i == 0) continue;
            b = this.data.slice((i - 32) * 8, 256);
            hexdata.append(b.toHexString());
            chardata.append(new Char(b).toString());
            Object[] args = new Object[]{hexdata, chardata};
            if (first) {
                fmtdata.append(Formatter.jsprintf("{0,64,L}\t*{1,32,L}*\n", args));
                first = false;
            } else {
                fmtdata.append(Formatter.jsprintf("\t\t\t    {0,64,L}\t*{1,32,L}*\n", args));
            }
            hexdata = new StringBuffer(32);
            chardata = new StringBuffer(32);
        }
        b = this.data.slice(i = i < 32 ? 0 : (i - i % 32) * 8);
        String hex = b.toHexString();
        if (hex.equals("")) {
            return fmtdata.toString();
        }
        hexdata.append(hex);
        chardata.append(new Char(b).toString());
        Object[] args = new Object[]{hexdata, chardata};
        if (first) {
            fmtdata.append(Formatter.jsprintf("{0,64,L}\t*{1,32,L}*\n", args));
        } else {
            fmtdata.append(Formatter.jsprintf("\t\t\t    {0,64,L}\t*{1,32,L}*\n", args));
            first = false;
        }
        return fmtdata.toString();
    }
}

