/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.CommandLineArguments;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.JarMaker;

public class ToolboxJarMaker
extends JarMaker {
    static final String[] VALID_COMPONENTS = new String[]{"AS400", "CommandCall", "ConnectionPool", "DataArea", "DataDescription", "DataQueue", "DigitalCertificate", "FTP", "IntegratedFileSystem", "JAAS", "JavaApplicationCall", "JDBC", "Job", "Message", "NetServer", "NumericDataTypes", "PCML", "Print", "ProgramCall", "RecordLevelAccess", "SecureAS400", "ServiceProgramCall", "SystemStatus", "SystemValue", "Trace", "User", "UserSpace", "AS400Visual", "CommandCallVisual", "DataQueueVisual", "IntegratedFileSystemVisual", "JavaApplicationCallVisual", "JDBCVisual", "JobVisual", "MessageVisual", "PrintVisual", "ProgramCallVisual", "RecordLevelAccessVisual", "UserVisual"};
    static final String[] VALID_COMPONENT_ABBREVS = new String[]{"AS400", "CmdCall", "ConnPool", "DA", "DD", "DQ", "DigCert", "FTP", "IFS", "JAAS", "JavaApp", "JDBC", "Job", "Msg", "NetS", "DataType", "PCML", "Prt", "PgmCall", "RLA", "Secure", "SvcPgmCall", "SysStat", "SysVal", "Trace", "User", "UserSpc", "AS400V", "CmdCallV", "DQV", "IFSV", "JavaAppV", "JDBCV", "JobV", "MsgV", "PrtV", "PgmCallV", "RLAV", "UserV"};
    public static final Integer AS400 = 0;
    public static final Integer COMMAND_CALL = 1;
    public static final Integer CONNECTION_POOL = 2;
    public static final Integer DATA_AREA = 3;
    public static final Integer DATA_DESCRIPTION = 4;
    public static final Integer DATA_QUEUE = 5;
    public static final Integer DIGITAL_CERTIFICATE = 6;
    public static final Integer FTP = 7;
    public static final Integer INTEGRATED_FILE_SYSTEM = 8;
    public static final Integer JAAS = 9;
    public static final Integer JAVA_APPLICATION_CALL = 10;
    public static final Integer JDBC = 11;
    public static final Integer JOB = 12;
    public static final Integer MESSAGE = 13;
    public static final Integer NETSERVER = 14;
    public static final Integer NUMERIC_DATA_TYPES = 15;
    public static final Integer PCML = 16;
    public static final Integer PRINT = 17;
    public static final Integer PROGRAM_CALL = 18;
    public static final Integer RECORD_LEVEL_ACCESS = 19;
    public static final Integer SECURE_AS400 = 20;
    public static final Integer SERVICE_PROGRAM_CALL = 21;
    public static final Integer SYSTEM_STATUS = 22;
    public static final Integer SYSTEM_VALUE = 23;
    public static final Integer TRACE = 24;
    public static final Integer USER = 25;
    public static final Integer USER_SPACE = 26;
    public static final Integer AS400_VISUAL = 27;
    public static final Integer COMMAND_CALL_VISUAL = 28;
    public static final Integer DATA_QUEUE_VISUAL = 29;
    public static final Integer INTEGRATED_FILE_SYSTEM_VISUAL = 30;
    public static final Integer JAVA_APPLICATION_CALL_VISUAL = 31;
    public static final Integer JDBC_VISUAL = 32;
    public static final Integer JOB_VISUAL = 33;
    public static final Integer MESSAGE_VISUAL = 34;
    public static final Integer PRINT_VISUAL = 35;
    public static final Integer PROGRAM_CALL_VISUAL = 36;
    public static final Integer RECORD_LEVEL_ACCESS_VISUAL = 37;
    public static final Integer USER_VISUAL = 38;
    private static final String CIAA = "com/ibm/as400/access/";
    private static final String CIAD = "com/ibm/as400/data/";
    private static final String CIAV = "com/ibm/as400/vaccess/";
    private static final String CIASA = "com/ibm/as400/security/auth/";
    private static final String COPYRIGHT_ENTRY_NAME = "com/ibm/as400/access/Copyright.class";
    static final String DEFAULT_SOURCE_JAR_NAME = "jt400.jar";
    private Vector components_ = new Vector();
    private Vector languages_ = new Vector();
    private File languageDirectory_ = new File(System.getProperty("user.dir"));
    private Vector ccsids_ = new Vector();
    private Vector ccsidsExcluded_ = new Vector();
    private boolean noProxy_;
    private boolean excludeResource_;
    private boolean excludeJDBC_;
    private boolean excludeRLA_;
    private boolean excludeSysVal_;
    private boolean excludeDirEntryClass_;
    private boolean excludeSecAuth_;
    private boolean excludeValidationList_;
    private boolean excludePathOptimizer_;
    private boolean excludeBidi_;
    private Arguments arguments_ = new Arguments();

    public ToolboxJarMaker() {
        super("com/ibm/as400");
        File defaultSourceJar = new File(DEFAULT_SOURCE_JAR_NAME);
        this.setSourceJar(defaultSourceJar);
    }

    private void addLanguageFiles(File baseDirectory, Vector neededJarEntries, JarMaker.JarMap jarMap) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory");
        }
        if (neededJarEntries == null) {
            throw new NullPointerException("neededJarEntries");
        }
        if (jarMap == null) {
            throw new NullPointerException("jarMap");
        }
        Vector<String> neededLanguageEntries = new Vector<String>();
        Enumeration e = neededJarEntries.elements();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (entryName.lastIndexOf("MRI") <= entryName.lastIndexOf(47)) continue;
            neededLanguageEntries.addElement(entryName);
        }
        if (this.languages_.size() != 0) {
            Vector<File> filesToAdd = new Vector<File>();
            Enumeration e1 = this.languages_.elements();
            while (e1.hasMoreElements()) {
                String languageSuffix = (String)e1.nextElement();
                Enumeration e2 = neededLanguageEntries.elements();
                while (e2.hasMoreElements()) {
                    String entryName = (String)e2.nextElement();
                    String newEntryName = ToolboxJarMaker.addMriSuffix(entryName, languageSuffix);
                    String filePath = ToolboxJarMaker.generateFilePath(this.languageDirectory_, newEntryName);
                    filesToAdd.addElement(new File(filePath));
                }
            }
            this.setAdditionalFiles(filesToAdd, baseDirectory);
        } else {
            Enumeration e1 = neededLanguageEntries.elements();
            while (e1.hasMoreElements()) {
                String entryName = (String)e1.nextElement();
                String entryName_en = ToolboxJarMaker.addMriSuffix(entryName, "en");
                String entryName_en_US = ToolboxJarMaker.addMriSuffix(entryName, "en_US");
                if (jarMap.contains(entryName_en) && !neededJarEntries.contains(entryName_en)) {
                    neededJarEntries.addElement(entryName_en);
                }
                if (!jarMap.contains(entryName_en_US) || neededJarEntries.contains(entryName_en_US)) continue;
                neededJarEntries.addElement(entryName_en_US);
            }
        }
    }

    private static String addMriSuffix(String entryName, String languageSuffix) {
        int insertionPosition = entryName.lastIndexOf(46);
        if (insertionPosition == -1) {
            insertionPosition = entryName.length();
        }
        StringBuffer buf = new StringBuffer(entryName);
        buf.insert(insertionPosition, "_" + languageSuffix);
        return buf.toString();
    }

    private static void addPcmlFiles(Vector neededJarEntries, JarMaker.JarMap jarMap) {
        if (neededJarEntries == null) {
            throw new NullPointerException("neededJarEntries");
        }
        if (jarMap == null) {
            throw new NullPointerException("jarMap");
        }
        Enumeration e = jarMap.elements();
        Vector<String> neededPcmlEntries = new Vector<String>();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (!entryName.endsWith(".pcml") && !entryName.endsWith(".pcml.ser")) continue;
            neededPcmlEntries.addElement(entryName);
        }
        Enumeration e1 = neededPcmlEntries.elements();
        while (e1.hasMoreElements()) {
            String pcmlEntryName = (String)e1.nextElement();
            String classEntryName = ToolboxJarMaker.getClassEntryForPcml(pcmlEntryName);
            if (!neededJarEntries.contains(classEntryName) || neededJarEntries.contains(pcmlEntryName)) continue;
            neededJarEntries.addElement(pcmlEntryName);
        }
    }

    @Override
    Vector adjustDependencies1(Vector neededJarEntries, JarMaker.JarMap jarMap) throws IOException {
        if (this.ccsids_.size() != 0) {
            if (this.components_.contains(INTEGRATED_FILE_SYSTEM)) {
                ToolboxJarMaker.addElement(this.ccsids_, 61952);
            }
            ToolboxJarMaker.addElement(this.ccsids_, 13488);
            Enumeration e3 = this.ccsids_.elements();
            while (e3.hasMoreElements()) {
                Integer ccsid = (Integer)e3.nextElement();
                String entry = "com/ibm/as400/access/ConvTable" + ccsid.toString() + ".class";
                if (neededJarEntries.contains(entry)) continue;
                if (jarMap.contains(entry)) {
                    neededJarEntries.addElement(entry);
                    continue;
                }
                System.err.println("Warning: No entry in source file for CCSID " + ccsid.toString() + ".");
            }
        }
        if (this.noProxy_) {
            ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ProxyClientConnection.class");
            ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ProxyReturnValue.class");
            if (this.verbose_) {
                System.out.println("Excluding Proxy* class dependencies.");
            }
        }
        if (this.excludeSomeDependencies_) {
            boolean accessPackageWasSpecified = this.getPackages().contains("com.ibm.as400.access");
            if (!(accessPackageWasSpecified || this.components_.isEmpty() || this.components_.contains(JDBC) || this.components_.contains(JDBC_VISUAL))) {
                this.excludeJDBC_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding JDBC classes.");
                }
                if (!this.getFilesRequired().contains("com/ibm/as400/access/DBBaseReplyDS.class")) {
                    ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/DBBaseReplyDS.class");
                    if (this.verbose_) {
                        System.out.println("Excluding dependency: com/ibm/as400/access/DBBaseReplyDS.class");
                    }
                    if (!this.getFilesRequired().contains("com/ibm/as400/access/DBDSPool.class")) {
                        ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/DBDSPool.class");
                        if (this.verbose_) {
                            System.out.println("Excluding dependency: com/ibm/as400/access/DBDSPool.class");
                        }
                    }
                }
            }
            if (!(this.getPackages().contains("com.ibm.as400.resource") || this.getFilesRequired().contains("com/ibm/as400/resource/RJob.class") || this.getFilesRequired().contains("com/ibm/as400/access/JobLog.class") || this.components_.isEmpty() || this.components_.contains(JOB) || this.components_.contains(JOB_VISUAL))) {
                this.excludeResource_ = true;
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/resource/RJob.class");
                if (this.verbose_) {
                    System.out.println("Excluding package com.ibm.as400.resource");
                }
            }
            if (!(accessPackageWasSpecified || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/DDM") || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/Record") || this.components_.isEmpty() || this.components_.contains(RECORD_LEVEL_ACCESS) || this.components_.contains(RECORD_LEVEL_ACCESS_VISUAL) || this.components_.contains(DATA_DESCRIPTION))) {
                this.excludeRLA_ = true;
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/Record.class");
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/CharacterFieldDescription.class");
                if (this.verbose_) {
                    System.out.println("Excluding Record Level Access classes.");
                }
            }
            if (this.excludeJDBC_) {
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/AS400JDBCConnection.class");
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/JDProperties.class");
                if (this.verbose_) {
                    System.out.println("Excluding dependencies: com/ibm/as400/access/AS400JDBCConnection.class, com/ibm/as400/access/JDProperties.class");
                }
            }
            if (this.excludeJDBC_ && this.excludeRLA_) {
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ClassDecoupler.class");
                if (this.verbose_) {
                    System.out.println("Excluding dependency: com/ibm/as400/access/ClassDecoupler.class");
                }
            }
            if (!(accessPackageWasSpecified || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/SystemValue") || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/SV") || this.components_.isEmpty() || this.components_.contains(SYSTEM_VALUE))) {
                this.excludeSysVal_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding System Value classes.");
                }
            }
            if (!this.getPackages().contains("com.ibm.as400.security.auth") && !this.getFilesRequired().contains("com/ibm/as400/security/auth/ProfileTokenCredential.class")) {
                this.excludeSecAuth_ = true;
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/security/auth/ProfileTokenCredential.class");
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/security/auth/AS400Credential.class");
                if (this.verbose_) {
                    System.out.println("Excluding ProfileTokenCredential dependencies.");
                }
            }
            if (!(accessPackageWasSpecified || ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/Directory") || this.components_.isEmpty() || this.components_.contains(USER) || this.components_.contains(USER_VISUAL))) {
                this.excludeDirEntryClass_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding DirectoryEntry classes.");
                }
            }
            if (!(accessPackageWasSpecified || this.components_.isEmpty() || this.components_.contains(JOB) || this.components_.contains(JOB_VISUAL))) {
                if (this.verbose_) {
                    System.out.println("Excluding Job classes from dependency analysis.");
                }
                if (!this.getFilesRequired().contains("com/ibm/as400/access/Job.class")) {
                    ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/Job.class");
                    if (this.verbose_) {
                        System.out.println("Excluding dependency: com/ibm/as400/access/Job.class");
                    }
                }
            }
            if (!accessPackageWasSpecified && !ToolboxJarMaker.containsPattern(this.getFilesRequired(), "com/ibm/as400/access/ValidationList")) {
                this.excludeValidationList_ = true;
                ToolboxJarMaker.addElement(this.dependenciesToExclude_, "com/ibm/as400/access/ValidationList.class");
                if (this.verbose_) {
                    System.out.println("Excluding ValidationList classes.");
                }
            }
            if (!this.getPackages().contains("com.ibm.as400.util") && !this.getFilesRequired().contains("com/ibm/as400/util/AS400ClassPathOptimizer.class")) {
                this.excludePathOptimizer_ = true;
                if (this.verbose_) {
                    System.out.println("Excluding AS400ClassPathOptimizer.");
                }
            }
            if (ToolboxJarMaker.isOkToExcludeBidi(this.components_, this.languages_, this.ccsids_)) {
                this.excludeBidi_ = true;
            }
        }
        return neededJarEntries;
    }

    private static final boolean isOkToExcludeBidi(Vector components, Vector languages, Vector ccsidList) {
        if (languages.isEmpty() && ccsidList.isEmpty()) {
            return false;
        }
        if (languages.contains("ar") || languages.contains("he")) {
            return false;
        }
        if (ccsidList.isEmpty()) {
            return true;
        }
        int[] ccsids = new int[ccsidList.size()];
        for (int i = 0; i < ccsids.length; ++i) {
            ccsids[i] = (Integer)ccsidList.get(i);
        }
        Arrays.sort(ccsids);
        return !ToolboxJarMaker.contains(ccsids, 1046) && !ToolboxJarMaker.contains(ccsids, 1089) && !ToolboxJarMaker.contains(ccsids, 1255) && !ToolboxJarMaker.contains(ccsids, 1256) && !ToolboxJarMaker.contains(ccsids, 12708) && !ToolboxJarMaker.contains(ccsids, 420) && !ToolboxJarMaker.contains(ccsids, 424) && !ToolboxJarMaker.contains(ccsids, 425) && !ToolboxJarMaker.contains(ccsids, 5351) && !ToolboxJarMaker.contains(ccsids, 62211) && !ToolboxJarMaker.contains(ccsids, 62224) && !ToolboxJarMaker.contains(ccsids, 62235) && !ToolboxJarMaker.contains(ccsids, 62245) && !ToolboxJarMaker.contains(ccsids, 62251) && !ToolboxJarMaker.contains(ccsids, 8612) && !ToolboxJarMaker.contains(ccsids, 862) && !ToolboxJarMaker.contains(ccsids, 864) && !ToolboxJarMaker.contains(ccsids, 916);
    }

    @Override
    Vector adjustDependencies2(Vector neededJarEntries, JarMaker.JarMap jarMap) throws IOException {
        Enumeration e2;
        Vector<String> entriesToRemove;
        String className;
        String entry;
        Enumeration e;
        String entry1 = "com/ibm/as400/access/ConvTableJavaMap.class";
        boolean jarIsPreMod4 = !jarMap.contains(entry1);
        if (neededJarEntries.contains("com/ibm/as400/access/ConvTable.class")) {
            if (this.ccsids_.size() == 0) {
                if (!jarIsPreMod4) {
                    Vector<String> entriesToAdd = new Vector<String>();
                    e = jarMap.elements();
                    while (e.hasMoreElements()) {
                        entry = (String)e.nextElement();
                        className = entry.substring(1 + entry.lastIndexOf(47));
                        if (!className.startsWith("ConvTable") || !Character.isDigit(className.charAt(9))) continue;
                        entriesToAdd.addElement(entry);
                    }
                    Enumeration e1 = entriesToAdd.elements();
                    Vector unanalyzedEntries = jarMap.getEntryNames();
                    Vector referencedJarEntries = new Vector();
                    while (e1.hasMoreElements()) {
                        String entryName = (String)e1.nextElement();
                        if (!unanalyzedEntries.contains(entryName)) continue;
                        unanalyzedEntries.removeElement(entryName);
                        this.analyzeJarEntry(entryName, unanalyzedEntries, referencedJarEntries, jarMap);
                        ToolboxJarMaker.addElement(referencedJarEntries, entryName);
                    }
                    ToolboxJarMaker.copyVector(referencedJarEntries, neededJarEntries, true);
                }
            } else if (jarIsPreMod4 && this.ccsids_.size() != 0) {
                entriesToRemove = new Vector<String>();
                e = neededJarEntries.elements();
                while (e.hasMoreElements()) {
                    entry = (String)e.nextElement();
                    className = entry.substring(1 + entry.lastIndexOf(47));
                    if (!className.startsWith("ConvTable") || !Character.isDigit(className.charAt(9))) continue;
                    entriesToRemove.addElement(entry);
                }
                e2 = entriesToRemove.elements();
                while (e2.hasMoreElements()) {
                    neededJarEntries.removeElement((String)e2.nextElement());
                }
                if (this.components_.contains(INTEGRATED_FILE_SYSTEM)) {
                    ToolboxJarMaker.addElement(this.ccsids_, 61952);
                }
                ToolboxJarMaker.addElement(this.ccsids_, 13488);
                Enumeration e3 = this.ccsids_.elements();
                while (e3.hasMoreElements()) {
                    Integer ccsid = (Integer)e3.nextElement();
                    String entry2 = "com/ibm/as400/access/ConvTable" + ccsid.toString() + ".class";
                    if (neededJarEntries.contains(entry2)) continue;
                    if (jarMap.contains(entry2)) {
                        neededJarEntries.addElement(entry2);
                        continue;
                    }
                    System.err.println("Warning: No entry in source file for CCSID " + ccsid.toString() + ".");
                }
            }
        }
        if (this.ccsidsExcluded_.size() != 0) {
            Enumeration e3 = this.ccsidsExcluded_.elements();
            while (e3.hasMoreElements()) {
                Integer ccsid = (Integer)e3.nextElement();
                entry = "com/ibm/as400/access/ConvTable" + ccsid.toString() + ".class";
                neededJarEntries.removeElement(entry);
                if (jarMap.contains(entry)) continue;
                System.err.println("Warning: No entry in source file for excluded CCSID " + ccsid.toString() + ".");
            }
        }
        ToolboxJarMaker.removePackageFiles(neededJarEntries, jarMap, this.getPackagesExcluded());
        ToolboxJarMaker.addPackageFiles(neededJarEntries, jarMap, this.getPackages());
        this.addLanguageFiles(this.languageDirectory_, neededJarEntries, jarMap);
        ToolboxJarMaker.addPcmlFiles(neededJarEntries, jarMap);
        if (this.noProxy_) {
            entriesToRemove = new Vector();
            e = neededJarEntries.elements();
            while (e.hasMoreElements()) {
                entry = (String)e.nextElement();
                className = entry.substring(1 + entry.lastIndexOf(47));
                if (!className.endsWith(".class") || !(className = className.substring(0, className.lastIndexOf(".class"))).endsWith("Proxy") && !className.endsWith("ProxyImpl") && !className.startsWith("Proxy") && !className.startsWith("Px")) continue;
                entriesToRemove.addElement(entry);
                if (!this.verbose_) continue;
                System.out.println("Excluding proxy class: " + className);
            }
            e2 = entriesToRemove.elements();
            while (e2.hasMoreElements()) {
                neededJarEntries.removeElement((String)e2.nextElement());
            }
        }
        if (this.excludeJDBC_) {
            neededJarEntries.removeElement("com/ibm/as400/access/DBDSPool.class");
        }
        if (this.excludeResource_) {
            ToolboxJarMaker.removeElements(neededJarEntries, "com/ibm/as400/resource/", 1);
        }
        if (this.excludeRLA_) {
            ToolboxJarMaker.removeElements(neededJarEntries, "com/ibm/as400/access/Record", 1);
            ToolboxJarMaker.removeElements(neededJarEntries, "FieldDescription.class", 2);
        }
        if (this.excludeSysVal_) {
            ToolboxJarMaker.removeElements(neededJarEntries, "com/ibm/as400/access/SV", 1);
        }
        if (this.excludeSecAuth_) {
            ToolboxJarMaker.addElement(neededJarEntries, "com/ibm/as400/security/auth/ProfileTokenCredential.class");
            ToolboxJarMaker.addElement(neededJarEntries, "com/ibm/as400/security/auth/AS400Credential.class");
            ToolboxJarMaker.addElement(neededJarEntries, "com/ibm/as400/security/auth/AS400BasicAuthenticationCredential.class");
            ToolboxJarMaker.addElement(neededJarEntries, "com/ibm/as400/security/auth/AS400SwappableCredential.class");
        }
        if (this.excludeDirEntryClass_) {
            ToolboxJarMaker.removeElements(neededJarEntries, "com/ibm/as400/access/DirectoryEntry", 1);
        }
        if (this.excludeValidationList_) {
            neededJarEntries.removeElement("com/ibm/as400/access/PersistenceException.class");
            ToolboxJarMaker.removeElements(neededJarEntries, "com/ibm/as400/access/ValidationList", 1);
        }
        if (this.excludePathOptimizer_) {
            neededJarEntries.removeElement("com/ibm/as400/util/AS400ClassPathOptimizer.class");
        }
        if (this.excludeBidi_) {
            ToolboxJarMaker.removeElements(neededJarEntries, "Arabic", 3);
        }
        if (jarMap.contains(COPYRIGHT_ENTRY_NAME)) {
            ToolboxJarMaker.addElement(neededJarEntries, COPYRIGHT_ENTRY_NAME);
        }
        return neededJarEntries;
    }

    private static boolean containsPattern(Vector list, String pattern) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            String elem = (String)e.nextElement();
            if (!elem.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    private static Vector getBaseDependenciesForComponent(Integer comp, boolean includeBeans) {
        Vector<String> deps = new Vector<String>();
        if (comp.equals(AS400)) {
            deps.addElement("com/ibm/as400/access/AS400.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400BeanInfo.class");
            }
        } else if (comp.equals(COMMAND_CALL)) {
            deps.addElement("com/ibm/as400/access/CommandCall.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/CommandCallBeanInfo.class");
            }
        } else if (comp.equals(CONNECTION_POOL)) {
            deps.addElement("com/ibm/as400/access/AS400ConnectionPool.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400ConnectionPoolBeanInfo.class");
                deps.addElement("com/ibm/as400/access/ConnectionPoolBeanInfo.class");
            }
        } else if (comp.equals(DATA_AREA)) {
            deps.addElement("com/ibm/as400/access/CharacterDataArea.class");
            deps.addElement("com/ibm/as400/access/DecimalDataArea.class");
            deps.addElement("com/ibm/as400/access/LocalDataArea.class");
            deps.addElement("com/ibm/as400/access/LogicalDataArea.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/CharacterDataAreaBeanInfo.class");
                deps.addElement("com/ibm/as400/access/DecimalDataAreaBeanInfo.class");
                deps.addElement("com/ibm/as400/access/LocalDataAreaBeanInfo.class");
                deps.addElement("com/ibm/as400/access/LogicalDataAreaBeanInfo.class");
            }
        } else if (comp.equals(DATA_DESCRIPTION)) {
            deps.addElement("com/ibm/as400/access/ArrayFieldDescription.class");
            deps.addElement("com/ibm/as400/access/BinaryFieldDescription.class");
            deps.addElement("com/ibm/as400/access/CharacterFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DateFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSEitherFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSGraphicFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSOnlyFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSOpenFieldDescription.class");
            deps.addElement("com/ibm/as400/access/FloatFieldDescription.class");
            deps.addElement("com/ibm/as400/access/HexFieldDescription.class");
            deps.addElement("com/ibm/as400/access/PackedDecimalFieldDescription.class");
            deps.addElement("com/ibm/as400/access/TimeFieldDescription.class");
            deps.addElement("com/ibm/as400/access/TimestampFieldDescription.class");
            deps.addElement("com/ibm/as400/access/VariableLengthFieldDescription.class");
            deps.addElement("com/ibm/as400/access/ZonedDecimalFieldDescription.class");
            deps.addElement("com/ibm/as400/access/AS400Array.class");
            deps.addElement("com/ibm/as400/access/AS400Bin2.class");
            deps.addElement("com/ibm/as400/access/AS400Bin4.class");
            deps.addElement("com/ibm/as400/access/AS400ByteArray.class");
            deps.addElement("com/ibm/as400/access/AS400Float4.class");
            deps.addElement("com/ibm/as400/access/AS400Float8.class");
            deps.addElement("com/ibm/as400/access/AS400PackedDecimal.class");
            deps.addElement("com/ibm/as400/access/AS400Structure.class");
            deps.addElement("com/ibm/as400/access/AS400Text.class");
            deps.addElement("com/ibm/as400/access/AS400UnsignedBin2.class");
            deps.addElement("com/ibm/as400/access/AS400UnsignedBin4.class");
            deps.addElement("com/ibm/as400/access/AS400ZonedDecimal.class");
            deps.addElement("com/ibm/as400/access/Record.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400ArrayBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400StructureBeanInfo.class");
                deps.addElement("com/ibm/as400/access/RecordBeanInfo.class");
                deps.addElement("com/ibm/as400/access/RecordFormatBeanInfo.class");
            }
        } else if (comp.equals(DATA_QUEUE)) {
            deps.addElement("com/ibm/as400/access/DataQueue.class");
            deps.addElement("com/ibm/as400/access/KeyedDataQueue.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/BaseDataQueueBeanInfo.class");
                deps.addElement("com/ibm/as400/access/DataQueueAttributesBeanInfo.class");
                deps.addElement("com/ibm/as400/access/DataQueueBeanInfo.class");
                deps.addElement("com/ibm/as400/access/KeyedDataQueueBeanInfo.class");
            }
        } else if (comp.equals(DIGITAL_CERTIFICATE)) {
            deps.addElement("com/ibm/as400/access/AS400Certificate.class");
            deps.addElement("com/ibm/as400/access/AS400CertificateAttribute.class");
            deps.addElement("com/ibm/as400/access/AS400CertificateUserProfileUtil.class");
            deps.addElement("com/ibm/as400/access/AS400CertificateVldlUtil.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400CertificateUserProfileUtilBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400CertificateUtilBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400CertificateVldlUtilBeanInfo.class");
            }
        } else if (comp.equals(FTP)) {
            deps.addElement("com/ibm/as400/access/AS400FTP.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400FTPBeanInfo.class");
                deps.addElement("com/ibm/as400/access/FTPBeanInfo.class");
            }
        } else if (comp.equals(INTEGRATED_FILE_SYSTEM)) {
            deps.addElement("com/ibm/as400/access/IFSFile.class");
            deps.addElement("com/ibm/as400/access/IFSRandomAccessFile.class");
            deps.addElement("com/ibm/as400/access/IFSTextFileInputStream.class");
            deps.addElement("com/ibm/as400/access/IFSTextFileOutputStream.class");
            deps.addElement("com/ibm/as400/access/IFSFileReader.class");
            deps.addElement("com/ibm/as400/access/IFSFileWriter.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/IFSFileBeanInfo.class");
                deps.addElement("com/ibm/as400/access/IFSRandomAccessFileBeanInfo.class");
                deps.addElement("com/ibm/as400/access/IFSTextFileInputStreamBeanInfo.class");
                deps.addElement("com/ibm/as400/access/IFSTextFileOutputStreamBeanInfo.class");
            }
        } else if (comp.equals(JAAS)) {
            deps.addElement("com/ibm/as400/security/auth/ProfileHandleCredential.class");
            deps.addElement("com/ibm/as400/security/auth/ProfileTokenCredential.class");
            deps.addElement("com/ibm/as400/security/auth/UserProfilePrincipal.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/security/auth/ProfileHandleCredentialBeanInfo.class");
                deps.addElement("com/ibm/as400/security/auth/ProfileTokenCredentialBeanInfo.class");
                deps.addElement("com/ibm/as400/security/auth/UserProfilePrincipalBeanInfo.class");
            }
        } else if (comp.equals(JAVA_APPLICATION_CALL)) {
            deps.addElement("com/ibm/as400/access/JavaApplicationCall.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/JavaApplicationCallBeanInfo.class");
            }
        } else if (comp.equals(JDBC)) {
            deps.addElement("com/ibm/as400/access/AS400JDBCDriver.class");
            deps.addElement("com/ibm/as400/access/AS400JDBCRowSet.class");
            deps.addElement("com/ibm/as400/access/AS400JDBCXAConnection.class");
            deps.addElement("com/ibm/as400/access/AS400JDBCConnectionPool.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400JDBCRowSetBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400JDBCDataSourceBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400JDBCXADataSourceBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400JDBCConnectionPoolBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400JDBCConnectionPoolDataSourceBeanInfo.class");
                deps.addElement("com/ibm/as400/access/ConnectionPoolBeanInfo.class");
            }
        } else if (comp.equals(JOB)) {
            deps.addElement("com/ibm/as400/access/JobList.class");
            deps.addElement("com/ibm/as400/access/JobLog.class");
            if (includeBeans) {
                // empty if block
            }
        } else if (comp.equals(MESSAGE)) {
            deps.addElement("com/ibm/as400/access/MessageQueue.class");
            if (includeBeans) {
                // empty if block
            }
        } else if (comp.equals(NETSERVER)) {
            deps.addElement("com/ibm/as400/access/ISeriesNetServer.class");
            deps.addElement("com/ibm/as400/access/NetServer.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/NetServerBeanInfo.class");
                deps.addElement("com/ibm/as400/access/NetServerFileShareBeanInfo.class");
                deps.addElement("com/ibm/as400/access/NetServerPrintShareBeanInfo.class");
            }
        } else if (comp.equals(NUMERIC_DATA_TYPES)) {
            deps.addElement("com/ibm/as400/access/AS400Array.class");
            deps.addElement("com/ibm/as400/access/AS400Bin2.class");
            deps.addElement("com/ibm/as400/access/AS400Bin4.class");
            deps.addElement("com/ibm/as400/access/AS400ByteArray.class");
            deps.addElement("com/ibm/as400/access/AS400Float4.class");
            deps.addElement("com/ibm/as400/access/AS400Float8.class");
            deps.addElement("com/ibm/as400/access/AS400PackedDecimal.class");
            deps.addElement("com/ibm/as400/access/AS400Structure.class");
            deps.addElement("com/ibm/as400/access/AS400UnsignedBin2.class");
            deps.addElement("com/ibm/as400/access/AS400UnsignedBin4.class");
            deps.addElement("com/ibm/as400/access/AS400ZonedDecimal.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400ArrayBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400StructureBeanInfo.class");
            }
        } else if (comp.equals(PCML)) {
            deps.addElement("com/ibm/as400/data/ProgramCallDocument.class");
            deps.addElement("com/ibm/as400/data/RecordFormatDocument.class");
            if (includeBeans) {
                // empty if block
            }
        } else if (comp.equals(PRINT)) {
            deps.addElement("com/ibm/as400/access/AFPResourceList.class");
            deps.addElement("com/ibm/as400/access/OutputQueueList.class");
            deps.addElement("com/ibm/as400/access/PrinterList.class");
            deps.addElement("com/ibm/as400/access/PrintObjectInputStream.class");
            deps.addElement("com/ibm/as400/access/SpooledFileList.class");
            deps.addElement("com/ibm/as400/access/SpooledFileOutputStream.class");
            deps.addElement("com/ibm/as400/access/SCS3812Writer.class");
            deps.addElement("com/ibm/as400/access/SCS5553Writer.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AFPResourceBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AFPResourceListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/OutputQueueBeanInfo.class");
                deps.addElement("com/ibm/as400/access/OutputQueueListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrintObjectBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrintObjectListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrinterBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrinterFileBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrinterFileListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/PrinterListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/SpooledFileListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/WriterJobListBeanInfo.class");
            }
        } else if (comp.equals(PROGRAM_CALL)) {
            deps.addElement("com/ibm/as400/access/ProgramCall.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/ProgramCallBeanInfo.class");
                deps.addElement("com/ibm/as400/access/ProgramParameterBeanInfo.class");
            }
        } else if (comp.equals(RECORD_LEVEL_ACCESS)) {
            deps.addElement("com/ibm/as400/access/AS400FileRecordDescription.class");
            deps.addElement("com/ibm/as400/access/KeyedFile.class");
            deps.addElement("com/ibm/as400/access/SequentialFile.class");
            deps.addElement("com/ibm/as400/access/DDMAS400MessageReply.class");
            deps.addElement("com/ibm/as400/access/DDMEndUnitOfWorkReply.class");
            deps.addElement("com/ibm/as400/access/DDMObjectDataStream.class");
            deps.addElement("com/ibm/as400/access/DDMRecordCache.class");
            deps.addElement("com/ibm/as400/access/DDMRequestDataStream.class");
            deps.addElement("com/ibm/as400/access/DDMS38IOFB.class");
            deps.addElement("com/ibm/as400/access/ArrayFieldDescription.class");
            deps.addElement("com/ibm/as400/access/BinaryFieldDescription.class");
            deps.addElement("com/ibm/as400/access/CharacterFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSEitherFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSGraphicFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSOnlyFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DBCSOpenFieldDescription.class");
            deps.addElement("com/ibm/as400/access/DateFieldDescription.class");
            deps.addElement("com/ibm/as400/access/FloatFieldDescription.class");
            deps.addElement("com/ibm/as400/access/HexFieldDescription.class");
            deps.addElement("com/ibm/as400/access/PackedDecimalFieldDescription.class");
            deps.addElement("com/ibm/as400/access/TimeFieldDescription.class");
            deps.addElement("com/ibm/as400/access/TimestampFieldDescription.class");
            deps.addElement("com/ibm/as400/access/ZonedDecimalFieldDescription.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/AS400FileBeanInfo.class");
                deps.addElement("com/ibm/as400/access/AS400FileRecordDescriptionBeanInfo.class");
                deps.addElement("com/ibm/as400/access/KeyedFileBeanInfo.class");
                deps.addElement("com/ibm/as400/access/SequentialFileBeanInfo.class");
            }
        } else if (comp.equals(SECURE_AS400)) {
            deps.addElement("com/ibm/as400/access/SecureAS400.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/SecureAS400BeanInfo.class");
            }
        } else if (comp.equals(SERVICE_PROGRAM_CALL)) {
            deps.addElement("com/ibm/as400/access/ServiceProgramCall.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/ServiceProgramCallBeanInfo.class");
            }
        } else if (comp.equals(SYSTEM_STATUS)) {
            deps.addElement("com/ibm/as400/access/SystemStatus.class");
            deps.addElement("com/ibm/as400/access/SystemPool.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/SystemStatusBeanInfo.class");
                deps.addElement("com/ibm/as400/access/SystemPoolBeanInfo.class");
            }
        } else if (comp.equals(SYSTEM_VALUE)) {
            deps.addElement("com/ibm/as400/access/SystemValueList.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/SystemValueListBeanInfo.class");
                deps.addElement("com/ibm/as400/access/SystemValueBeanInfo.class");
            }
        } else if (comp.equals(TRACE)) {
            deps.addElement("com/ibm/as400/access/Trace.class");
        } else if (comp.equals(USER)) {
            deps.addElement("com/ibm/as400/access/UserList.class");
            if (includeBeans) {
                // empty if block
            }
        } else if (comp.equals(USER_SPACE)) {
            deps.addElement("com/ibm/as400/access/UserSpace.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/access/UserSpaceBeanInfo.class");
            }
        } else if (comp.equals(AS400_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/ErrorDialogAdapter.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/ErrorDialogAdapterBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VActionAdapterBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VPropertiesActionBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/WorkingCursorAdapterBeanInfo.class");
            }
        } else if (comp.equals(COMMAND_CALL_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/CommandCallButton.class");
            deps.addElement("com/ibm/as400/vaccess/CommandCallMenuItem.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/CommandCallButtonBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/CommandCallMenuItemBeanInfo.class");
            }
        } else if (comp.equals(DATA_QUEUE_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/DataQueueDocument.class");
            deps.addElement("com/ibm/as400/vaccess/KeyedDataQueueDocument.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/DataQueueDocumentBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/KeyedDataQueueDocumentBeanInfo.class");
            }
        } else if (comp.equals(INTEGRATED_FILE_SYSTEM_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/IFSFileDialog.class");
            deps.addElement("com/ibm/as400/vaccess/IFSTextFileDocument.class");
            deps.addElement("com/ibm/as400/vaccess/VIFSDirectory.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/IFSTextFileDocumentBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VIFSDirectoryBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (comp.equals(JAVA_APPLICATION_CALL_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/VJavaApplicationCall.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/VJavaApplicationCallBeanInfo.class");
            }
        } else if (comp.equals(JDBC_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/SQLResultSetFormPane.class");
            deps.addElement("com/ibm/as400/vaccess/SQLResultSetTablePane.class");
            deps.addElement("com/ibm/as400/vaccess/SQLStatementButton.class");
            deps.addElement("com/ibm/as400/vaccess/SQLStatementMenuItem.class");
            deps.addElement("com/ibm/as400/vaccess/SQLStatementDocument.class");
            deps.addElement("com/ibm/as400/vaccess/SQLQueryBuilderPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/SQLConnectionBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLQueryBuilderPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLResultSetFormPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLResultSetTableModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLResultSetTablePaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLStatementButtonBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLStatementDocumentBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/SQLStatementMenuItemBeanInfo.class");
            }
        } else if (comp.equals(JOB_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/VJobList.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/VJobBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VJobListBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (comp.equals(MESSAGE_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/VMessageList.class");
            deps.addElement("com/ibm/as400/vaccess/VMessageQueue.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/VMessageListBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VMessageQueueBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (comp.equals(PRINT_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/VPrinters.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/VPrinterBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VPrinterOutputBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/VPrintersBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else if (comp.equals(PROGRAM_CALL_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/ProgramCallButton.class");
            deps.addElement("com/ibm/as400/vaccess/ProgramCallMenuItem.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/ProgramCallButtonBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/ProgramCallMenuItemBeanInfo.class");
            }
        } else if (comp.equals(RECORD_LEVEL_ACCESS_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/RecordListFormPane.class");
            deps.addElement("com/ibm/as400/vaccess/RecordListTablePane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/RecordListFormPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/RecordListTableModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/RecordListTablePaneBeanInfo.class");
            }
        } else if (comp.equals(USER_VISUAL)) {
            deps.addElement("com/ibm/as400/vaccess/VUserList.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPane.class");
            deps.addElement("com/ibm/as400/vaccess/AS400ListPane.class");
            if (includeBeans) {
                deps.addElement("com/ibm/as400/vaccess/VUserListBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400DetailsPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ExplorerPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400ListPaneBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreeModelBeanInfo.class");
                deps.addElement("com/ibm/as400/vaccess/AS400TreePaneBeanInfo.class");
            }
        } else {
            throw new IllegalArgumentException("component (" + comp + ")");
        }
        return deps;
    }

    public Vector getCCSIDs() {
        return this.ccsids_;
    }

    public Vector getCCSIDsExcluded() {
        return this.ccsidsExcluded_;
    }

    private static String getClassEntryForPcml(String pcmlEntryName) {
        int suffixPos = pcmlEntryName.lastIndexOf(".pcml");
        return pcmlEntryName.substring(0, suffixPos) + ".class";
    }

    private static Integer getComponentID(String componentName) {
        int i;
        String comp = componentName.trim();
        Integer id = null;
        for (i = 0; i < VALID_COMPONENTS.length; ++i) {
            if (!comp.equalsIgnoreCase(VALID_COMPONENTS[i])) continue;
            id = i;
            break;
        }
        if (id == null) {
            for (i = 0; i < VALID_COMPONENT_ABBREVS.length; ++i) {
                if (!comp.equalsIgnoreCase(VALID_COMPONENT_ABBREVS[i])) continue;
                id = i;
                break;
            }
        }
        return id;
    }

    public Vector getComponents() {
        return this.components_;
    }

    public File getLanguageDirectory() {
        return this.languageDirectory_;
    }

    public Vector getLanguages() {
        return this.languages_;
    }

    private static String getShippedLanguageSuffixFor(String langId, boolean verbose) {
        String result = null;
        String id = ToolboxJarMaker.normalizeLanguageSuffix(langId);
        if (id.startsWith("en")) {
            if (verbose) {
                System.out.println("English MRI files are included by default.");
            }
        } else if (id.startsWith("de_CH")) {
            result = "de_CH";
        } else if (id.startsWith("de")) {
            result = "de";
        } else if (id.startsWith("es")) {
            result = "es";
        } else if (id.startsWith("fr_BE")) {
            result = "fr_BE";
        } else if (id.startsWith("fr_CA")) {
            result = "fr_CA";
        } else if (id.startsWith("fr_CH")) {
            result = "fr_CH";
        } else if (id.startsWith("fr")) {
            result = "fr";
        } else if (id.startsWith("it_CH")) {
            result = "it_CH";
        } else if (id.startsWith("it")) {
            result = "it";
        } else if (id.startsWith("ja")) {
            result = "ja";
        } else if (id.startsWith("ko")) {
            result = "ko";
        } else if (id.startsWith("zh_TW")) {
            result = "zh_TW";
        } else if (id.startsWith("zh")) {
            result = "zh";
        } else if (id.startsWith("cs")) {
            result = "cs";
        } else if (id.startsWith("hu")) {
            result = "hu";
        } else if (id.startsWith("pl")) {
            result = "pl";
        } else {
            System.err.println("Warning: Unsupported language ID specified: " + langId + ".");
            result = id;
        }
        return result;
    }

    private static String normalizeLanguageSuffix(String language) {
        String languageID = language;
        String id = language.trim();
        while (id.charAt(0) == '_') {
            id = id.substring(1);
        }
        while (id.endsWith("_")) {
            id = id.substring(0, id.length() - 1);
        }
        if (id.length() < 2) {
            throw new IllegalArgumentException("language (" + language + ")");
        }
        if (id.indexOf("_") == 2) {
            languageID = id;
        } else {
            StringBuffer buf = new StringBuffer(id);
            buf.insert(2, '_');
            languageID = buf.toString();
        }
        String part1 = languageID.substring(0, 2).toLowerCase();
        String part2 = languageID.substring(2).toUpperCase();
        String result = part1 + part2;
        return result;
    }

    private boolean parseArgs(String[] args) {
        boolean succeeded = false;
        this.reset();
        succeeded = this.arguments_.parse(args, this);
        return succeeded;
    }

    @Override
    public void reset() {
        super.reset();
        this.arguments_ = new Arguments();
        File defaultSourceJar = new File(DEFAULT_SOURCE_JAR_NAME);
        this.setSourceJar(defaultSourceJar);
        this.components_.removeAllElements();
        this.languages_.removeAllElements();
        this.languageDirectory_ = new File(System.getProperty("user.dir"));
        this.ccsids_.removeAllElements();
        this.ccsidsExcluded_.removeAllElements();
    }

    public void setCCSIDs(Vector ccsidList) {
        if (ccsidList == null) {
            throw new NullPointerException("ccsidList");
        }
        ccsidList = ToolboxJarMaker.validateList(ccsidList, "CCSID", "java.lang.Integer", this.verbose_);
        Enumeration e = ccsidList.elements();
        while (e.hasMoreElements()) {
            Integer ccsid = (Integer)e.nextElement();
            ToolboxJarMaker.addElement(this.ccsids_, ccsid);
            if (this.ccsidsExcluded_.contains(ccsid)) {
                System.err.println("Warning: CCSID " + ccsid + ", specified for both inclusion and exclusion, will be included.");
                this.ccsidsExcluded_.removeElement(ccsid);
            }
            switch (ccsid) {
                case 930: 
                case 5026: {
                    ToolboxJarMaker.addElement(this.ccsids_, 290);
                    ToolboxJarMaker.addElement(this.ccsids_, 300);
                    break;
                }
                case 933: 
                case 1364: {
                    ToolboxJarMaker.addElement(this.ccsids_, 833);
                    ToolboxJarMaker.addElement(this.ccsids_, 834);
                    break;
                }
                case 935: 
                case 1388: {
                    ToolboxJarMaker.addElement(this.ccsids_, 836);
                    ToolboxJarMaker.addElement(this.ccsids_, 837);
                    break;
                }
                case 937: {
                    ToolboxJarMaker.addElement(this.ccsids_, 37);
                    ToolboxJarMaker.addElement(this.ccsids_, 835);
                    break;
                }
                case 939: 
                case 5035: {
                    ToolboxJarMaker.addElement(this.ccsids_, 1027);
                    ToolboxJarMaker.addElement(this.ccsids_, 300);
                    break;
                }
                case 1399: {
                    ToolboxJarMaker.addElement(this.ccsids_, 5123);
                    ToolboxJarMaker.addElement(this.ccsids_, 16684);
                    break;
                }
            }
        }
    }

    public void setCCSIDsExcluded(Vector ccsidList) {
        if (ccsidList == null) {
            throw new NullPointerException("ccsidList");
        }
        ccsidList = ToolboxJarMaker.validateList(ccsidList, "CCSID", "java.lang.Integer", this.verbose_);
        Enumeration e = ccsidList.elements();
        while (e.hasMoreElements()) {
            Integer ccsid = (Integer)e.nextElement();
            if (this.ccsids_.contains(ccsid)) {
                System.err.println("Warning: CCSID " + ccsid + ", specified for both exclusion and inclusion, will be included.");
                continue;
            }
            ToolboxJarMaker.addElement(this.ccsidsExcluded_, ccsid);
        }
    }

    public void setComponents(Vector components) {
        this.setComponents(components, false);
    }

    public void setComponents(Vector components, boolean includeBeans) {
        if (components == null) {
            throw new NullPointerException("componentList");
        }
        components = ToolboxJarMaker.validateList(components, "component", "java.lang.Integer", this.verbose_);
        Vector filesForComponents = new Vector();
        Enumeration e = components.elements();
        while (e.hasMoreElements()) {
            Integer comp = (Integer)e.nextElement();
            if (!ToolboxJarMaker.addElement(this.components_, comp)) continue;
            Vector filesForThisComp = ToolboxJarMaker.getBaseDependenciesForComponent(comp, includeBeans);
            ToolboxJarMaker.copyVector(filesForThisComp, filesForComponents, true);
        }
        this.setFilesRequired(filesForComponents);
    }

    public void setLanguageDirectory(File baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory");
        }
        this.languageDirectory_ = baseDirectory;
    }

    public void setLanguages(Vector languages) {
        if (languages == null) {
            throw new NullPointerException("languageList");
        }
        languages = ToolboxJarMaker.validateList(languages, "language", "java.lang.String", this.verbose_);
        Enumeration e = languages.elements();
        while (e.hasMoreElements()) {
            String specifiedLanguage = (String)e.nextElement();
            String mriSuffix = ToolboxJarMaker.getShippedLanguageSuffixFor(specifiedLanguage, this.verbose_);
            ToolboxJarMaker.addElement(this.languages_, mriSuffix);
        }
    }

    public void setProxyFilesExcluded(boolean excludeProxies) {
        this.noProxy_ = excludeProxies;
    }

    public void setExcludeSomeDependencies(boolean excludeSomeDependencies) {
        this.excludeSomeDependencies_ = excludeSomeDependencies;
    }

    public static void main(String[] args) {
        try {
            ToolboxJarMaker jm = new ToolboxJarMaker();
            if (jm.parseArgs(args)) {
                if (jm.isSplit()) {
                    File srcJar = jm.getSourceJar();
                    int splitSize = jm.getSplitSize();
                    jm.split(srcJar, splitSize);
                } else if (jm.isExtract()) {
                    File srcJar = jm.getSourceJar();
                    File outputDir = jm.getExtractionDirectory();
                    jm.extract(srcJar, outputDir);
                } else {
                    File srcJar = jm.getSourceJar();
                    File destJar = jm.getDestinationJar();
                    jm.makeJar(srcJar, destJar);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    class Arguments {
        Arguments() {
        }

        boolean parse(String[] argList, ToolboxJarMaker jmaker) {
            StringTokenizer st;
            String val;
            Vector components = null;
            Vector languages = null;
            Vector ccsids = null;
            Vector ccsidsExcluded = null;
            boolean includeBeans = false;
            boolean noProxySpecified = false;
            boolean succeeded = true;
            if (!jmaker.parseArgs(argList, true)) {
                this.printUsage(System.err);
                return false;
            }
            String[] args = jmaker.getUnrecognizedArgs();
            if (args.length == 0) {
                if (ToolboxJarMaker.this.requestedUsageInfo_) {
                    this.printUsage(System.out);
                    return false;
                }
                return succeeded;
            }
            Vector<String> options = new Vector<String>();
            options.addElement("-component");
            options.addElement("-beans");
            options.addElement("-language");
            options.addElement("-languageDirectory");
            options.addElement("-ccsid");
            options.addElement("-ccsidExcluded");
            options.addElement("-noProxy");
            options.addElement("-excludeSomeDependencies");
            Hashtable<String, String> shortcuts = new Hashtable<String, String>();
            shortcuts.put("-c", "-component");
            shortcuts.put("-comp", "-component");
            shortcuts.put("-b", "-beans");
            shortcuts.put("-l", "-language");
            shortcuts.put("-lang", "-language");
            shortcuts.put("-ld", "-languageDirectory");
            shortcuts.put("-langdir", "-languageDirectory");
            shortcuts.put("-languagedir", "-languageDirectory");
            shortcuts.put("-cc", "-ccsid");
            shortcuts.put("-cx", "-ccsidExcluded");
            shortcuts.put("-ccx", "-ccsidExcluded");
            shortcuts.put("-ccsidex", "-ccsidExcluded");
            shortcuts.put("-ccsidsex", "-ccsidExcluded");
            shortcuts.put("-np", "-noProxy");
            shortcuts.put("-npprox", "-noProxy");
            shortcuts.put("-xd", "-excludeSomeDependencies");
            shortcuts.put("-xsd", "-excludeSomeDependencies");
            shortcuts.put("-excludesome", "-excludeSomeDependencies");
            CommandLineArguments arguments = new CommandLineArguments(args, options, shortcuts);
            if (ToolboxJarMaker.this.verbose_) {
                System.out.print("Arguments parsed by ToolboxJarMaker: ");
                String opts = JarMaker.listCommandOptions(arguments, true);
                System.out.println(opts);
                opts = JarMaker.listCommandOptions(arguments, false);
                if (opts.length() != 0) {
                    System.out.print("Arguments unrecognized by ToolboxJarMaker: ");
                    System.out.println(opts);
                }
            }
            if ((val = arguments.getOptionValue("-component")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (components == null) {
                            components = new Vector(st.countTokens());
                        }
                        boolean badComponent = false;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            Integer component = ToolboxJarMaker.getComponentID(token);
                            if (component == null) {
                                System.err.println("Error: Unrecognized component name: " + token);
                                badComponent = true;
                                succeeded = false;
                                continue;
                            }
                            JarMaker.addElement(components, component);
                        }
                        if (badComponent && jmaker.isVerbose()) {
                            int j;
                            System.err.println("The recognized components are:");
                            for (j = 0; j < VALID_COMPONENTS.length - 1; ++j) {
                                System.err.print(VALID_COMPONENTS[j] + ", ");
                            }
                            System.err.println(VALID_COMPONENTS[j]);
                        }
                    }
                } else {
                    System.err.println("Warning: No component specified after -component.");
                }
            }
            includeBeans = arguments.isOptionSpecified("-beans");
            val = arguments.getOptionValue("-language");
            if (val != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (languages == null) {
                            languages = new Vector(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            JarMaker.addElement(languages, st.nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No language specified after -language.");
                }
            }
            if ((val = arguments.getOptionValue("-languageDirectory")) != null) {
                if (val.length() != 0) {
                    jmaker.setLanguageDirectory(new File(val));
                } else {
                    System.err.println("Warning: No directory specified after -languageDirectory.");
                }
            }
            if ((val = arguments.getOptionValue("-ccsid")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (ccsids == null) {
                            ccsids = new Vector(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            Integer ccsid = null;
                            try {
                                ccsid = Integer.valueOf(token);
                            }
                            catch (NumberFormatException e) {
                                System.err.println("Error: Non-integer CCSID value: " + token);
                                succeeded = false;
                                continue;
                            }
                            JarMaker.addElement(ccsids, ccsid);
                        }
                    }
                } else {
                    System.err.println("Warning: No CCSID specified after -ccsid.");
                }
            }
            if ((val = arguments.getOptionValue("-ccsidExcluded")) != null) {
                if (val.length() != 0) {
                    st = new StringTokenizer(val, ",");
                    if (st.countTokens() != 0) {
                        if (ccsidsExcluded == null) {
                            ccsidsExcluded = new Vector(st.countTokens());
                        }
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            Integer ccsid = null;
                            try {
                                ccsid = Integer.valueOf(token);
                            }
                            catch (NumberFormatException e) {
                                System.err.println("Error: Non-integer CCSID value: " + token);
                                succeeded = false;
                                continue;
                            }
                            JarMaker.addElement(ccsidsExcluded, ccsid);
                        }
                    }
                } else {
                    System.err.println("Warning: No CCSID specified after -ccsidExcluded.");
                }
            }
            if (arguments.isOptionSpecified("-noproxy")) {
                ToolboxJarMaker.this.noProxy_ = true;
                noProxySpecified = true;
            }
            ToolboxJarMaker.this.excludeSomeDependencies_ = arguments.isOptionSpecified("-excludeSomeDependencies");
            Enumeration enum1 = arguments.getExtraOptions();
            while (enum1.hasMoreElements()) {
                String optionName = (String)enum1.nextElement();
                String optionVal = arguments.getOptionValue(optionName);
                String optionWithVal = optionVal == null ? optionName : optionName + " " + optionVal;
                System.err.println("Error: Unrecognized option: " + optionWithVal);
                succeeded = false;
            }
            if (jmaker.isSplit()) {
                if (components != null || includeBeans || languages != null || ccsids != null || ccsidsExcluded != null) {
                    System.err.println("Warning: When -split is specified, all other options are ignored, except -source and -verbose.");
                }
            } else {
                if (!(jmaker.isOptionInfoSufficient() || components != null || languages != null || ccsids != null || ccsidsExcluded != null || noProxySpecified || ToolboxJarMaker.this.excludeSomeDependencies_)) {
                    System.err.println("Error: Need to specify more options.");
                    succeeded = false;
                }
                if (languages != null) {
                    ToolboxJarMaker.this.setLanguages(languages);
                }
                if (components != null) {
                    if (components.size() != 0) {
                        ToolboxJarMaker.this.setComponents(components, includeBeans);
                    } else {
                        succeeded = false;
                    }
                }
                if (ccsids != null) {
                    ToolboxJarMaker.this.setCCSIDs(ccsids);
                }
                if (ccsidsExcluded != null) {
                    ToolboxJarMaker.this.setCCSIDsExcluded(ccsidsExcluded);
                }
            }
            if (!succeeded) {
                this.printUsage(System.err);
            }
            return succeeded;
        }

        private void printUsage(PrintStream output) {
            output.println();
            output.println("Usage: ");
            output.println();
            output.println("  ToolboxJarMaker [-source jarFile]");
            output.println("           [-destination jarFile]");
            output.println("           [-fileRequired entry1[,entry2[...]]]");
            output.println("           [-fileExcluded entry1[,entry2[...]]]");
            output.println("           [-additionalFile file1[,file2[...]]]");
            output.println("           [-additionalFilesDirectory directory");
            output.println("           [-package pkg1[,pkg2[...]]]");
            output.println("           [-packageExcluded pkg1[,pkg2[...]]]");
            output.println("           [-extract [directory]]");
            output.println("           [-split [kilobytes]]");
            output.println("           [-component comp1[,comp2[...]]]");
            output.println("           [-beans]");
            output.println("           [-language language1[,language2[...]]]");
            output.println("           [-languageDirectory directory");
            output.println("           [-ccsid ccsid1[,ccsid2[...]]]");
            output.println("           [-ccsidExcluded ccsid1[,ccsid2[...]]]");
            output.println("           [-noProxy]");
            output.println("           [-excludeSomeDependencies]");
            output.println("           [-verbose]");
            output.println("           [-help]");
            output.println();
            output.println("At least one of the following options must be specified: ");
            output.println("-fileRequired, -fileExcluded, -additionalFile, -package, -packageExcluded, -extract, -split, -component, -language, -ccsid, -ccsidExcluded, -noProxy");
            output.println();
            output.println("The -excludeSomeDependencies option is not recommended for pre-V5R2 Toolbox JAR files.");
        }
    }
}

