/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.playlist.FilePlayListAll;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileInputMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransform;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransformData;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputReader;
import org.apache.hop.pipeline.transforms.file.IBaseFileInputTransformControl;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileFilterProcessor;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputData;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputReader;

public class TextFileInput
extends BaseFileInputTransform<TextFileInputMeta, TextFileInputData> {
    private static final Class<?> PKG = TextFileInputMeta.class;

    public TextFileInput(TransformMeta transformMeta, TextFileInputMeta meta, TextFileInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (BaseFileInputMeta)meta, (BaseFileInputTransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected IBaseFileInputReader createReader(TextFileInputMeta meta, TextFileInputData data, FileObject file) throws Exception {
        return new TextFileInputReader((IBaseFileInputTransformControl)this, meta, data, file, this.getLogChannel());
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        ((TextFileInputData)this.data).filePlayList = FilePlayListAll.INSTANCE;
        ((TextFileInputData)this.data).filterProcessor = new TextFileFilterProcessor(((TextFileInputMeta)this.meta).getFilter(), (IVariables)this);
        ((TextFileInputData)this.data).fileFormatType = ((TextFileInputMeta)this.meta).getFileFormatTypeNr();
        ((TextFileInputData)this.data).fileType = ((TextFileInputMeta)this.meta).getFileTypeNr();
        ((TextFileInputData)this.data).separator = this.resolve(((TextFileInputMeta)this.meta).content.separator);
        ((TextFileInputData)this.data).enclosure = this.resolve(((TextFileInputMeta)this.meta).content.enclosure);
        ((TextFileInputData)this.data).escapeCharacter = this.resolve(((TextFileInputMeta)this.meta).content.escapeCharacter);
        if (((TextFileInputMeta)this.meta).content.fileType.equalsIgnoreCase("CSV") && (((TextFileInputMeta)this.meta).content.separator == null || ((TextFileInputMeta)this.meta).content.separator.isEmpty())) {
            this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Exception.NoSeparator", (String[])new String[0]));
            return false;
        }
        return true;
    }
}

