/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.Preconditions;

public class ExecutionAttemptID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BYTE_BUF_LEN = 40;
    private final ExecutionGraphID executionGraphId;
    private final ExecutionVertexID executionVertexId;
    private final int attemptNumber;

    public ExecutionAttemptID(ExecutionGraphID executionGraphId, ExecutionVertexID executionVertexId, int attemptNumber) {
        Preconditions.checkArgument((attemptNumber >= 0 ? 1 : 0) != 0);
        this.executionGraphId = (ExecutionGraphID)((Object)Preconditions.checkNotNull((Object)((Object)executionGraphId)));
        this.executionVertexId = (ExecutionVertexID)Preconditions.checkNotNull((Object)executionVertexId);
        this.attemptNumber = attemptNumber;
    }

    public ExecutionVertexID getExecutionVertexId() {
        return this.executionVertexId;
    }

    public JobVertexID getJobVertexId() {
        return this.executionVertexId.getJobVertexId();
    }

    public int getSubtaskIndex() {
        return this.executionVertexId.getSubtaskIndex();
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public void writeTo(ByteBuf buf) {
        this.executionGraphId.writeTo(buf);
        this.executionVertexId.writeTo(buf);
        buf.writeInt(this.attemptNumber);
    }

    public static ExecutionAttemptID fromByteBuf(ByteBuf buf) {
        return new ExecutionAttemptID(ExecutionGraphID.fromByteBuf(buf), ExecutionVertexID.fromByteBuf(buf), buf.readInt());
    }

    public static int getByteBufLength() {
        return 40;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExecutionAttemptID that = (ExecutionAttemptID)obj;
            return that.executionGraphId.equals((Object)this.executionGraphId) && that.executionVertexId.equals(this.executionVertexId) && that.attemptNumber == this.attemptNumber;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionGraphId, this.executionVertexId, this.attemptNumber});
    }

    public String toString() {
        return String.format("%s_%s_%d", new Object[]{this.executionGraphId, this.executionVertexId, this.attemptNumber});
    }

    public static ExecutionAttemptID randomId() {
        return new ExecutionAttemptID(new ExecutionGraphID(), new ExecutionVertexID(new JobVertexID(0L, 0L), 0), 0);
    }
}

