/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.Serializable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class ProfilingInfo
implements ResponseBody,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_MODE = "mode";
    public static final String FIELD_NAME_TRIGGER_TIME = "triggerTime";
    public static final String FIELD_NAME_FINISHED_TIME = "finishedTime";
    public static final String FIELD_NAME_DURATION = "duration";
    public static final String FIELD_NAME_MESSAGE = "message";
    public static final String FIELD_NAME_OUTPUT_FILE = "outputFile";
    @JsonProperty(value="status")
    private ProfilingStatus status;
    @JsonProperty(value="mode")
    private ProfilingMode mode;
    @JsonProperty(value="triggerTime")
    private Long triggerTime;
    @JsonProperty(value="finishedTime")
    private Long finishedTime;
    @JsonProperty(value="duration")
    private Long duration;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="outputFile")
    private String outputFile;

    private ProfilingInfo() {
    }

    private ProfilingInfo(ProfilingStatus status, ProfilingMode mode, long triggerTime, long finishedTime, long duration, String message, String outputFile) {
        this.status = status;
        this.mode = mode;
        this.triggerTime = triggerTime;
        this.finishedTime = finishedTime;
        this.duration = duration;
        this.message = message;
        this.outputFile = outputFile;
    }

    public ProfilingInfo fail(String message) {
        this.status = ProfilingStatus.FAILED;
        this.message = message;
        this.finishedTime = System.currentTimeMillis();
        return this;
    }

    public ProfilingInfo success(String outputFile) {
        this.status = ProfilingStatus.FINISHED;
        this.finishedTime = System.currentTimeMillis();
        this.outputFile = outputFile;
        this.message = "Profiling Successful";
        return this;
    }

    public ProfilingStatus getStatus() {
        return this.status;
    }

    public ProfilingMode getProfilingMode() {
        return this.mode;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getFinishedTime() {
        return this.finishedTime;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public long getTriggerTime() {
        return this.triggerTime;
    }

    public static ProfilingInfo create(long duration, ProfilingMode mode) {
        ProfilingInfo profilingInfo = new ProfilingInfo();
        profilingInfo.mode = mode;
        profilingInfo.triggerTime = System.currentTimeMillis();
        profilingInfo.status = ProfilingStatus.RUNNING;
        profilingInfo.duration = duration;
        return profilingInfo;
    }

    @JsonCreator
    public static ProfilingInfo create(@JsonProperty(value="status") ProfilingStatus status, @JsonProperty(value="mode") ProfilingMode mode, @JsonProperty(value="triggerTime") long triggerTime, @JsonProperty(value="finishedTime") long finishedTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="message") String message, @JsonProperty(value="outputFile") String outputPath) {
        return new ProfilingInfo(status, mode, triggerTime, finishedTime, duration, message, outputPath);
    }

    public String toString() {
        return "ProfilingInfo{status=" + (Object)((Object)this.status) + ", mode=" + (Object)((Object)this.mode) + ", triggerTime=" + this.triggerTime + ", finishedTime=" + this.finishedTime + ", duration=" + this.duration + ", message='" + this.message + '\'' + ", outputFile='" + this.outputFile + '\'' + '}';
    }

    public static enum ProfilingMode {
        CPU,
        ALLOC,
        LOCK,
        WALL,
        ITIMER;


        public String getCode() {
            return this.name().toLowerCase();
        }
    }

    public static enum ProfilingStatus {
        RUNNING,
        FINISHED,
        FAILED;


        public boolean isRunning() {
            return this == RUNNING;
        }
    }
}

