/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class ParquetWriteSupport
extends WriteSupport<RowMetaAndData> {
    private final MessageType messageType;
    private final Schema avroSchema;
    private RecordConsumer recordConsumer;
    private final List<Integer> sourceFieldIndexes;
    private final List<ParquetField> fields;
    private Map<Integer, Schema> fieldSchemas;
    private Map<Integer, LogicalType> fieldTypes;

    public ParquetWriteSupport(MessageType messageType, Schema avroSchema, List<Integer> sourceFieldIndexes, List<ParquetField> fields) {
        this.messageType = messageType;
        this.avroSchema = avroSchema;
        this.sourceFieldIndexes = sourceFieldIndexes;
        this.fields = fields;
        this.fieldSchemas = new HashMap<Integer, Schema>();
        this.fieldTypes = new HashMap<Integer, LogicalType>();
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        return new WriteSupport.WriteContext(this.messageType, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(RowMetaAndData row) {
        this.recordConsumer.startMessage();
        try {
            for (int i = 0; i < this.fields.size(); ++i) {
                Object valueData;
                ParquetField field = this.fields.get(i);
                int index = this.sourceFieldIndexes.get(i);
                IValueMeta valueMeta = row.getValueMeta(index);
                boolean isNull = valueMeta.isNull(valueData = row.getData()[index]);
                if (isNull) continue;
                this.recordConsumer.startField(field.getTargetFieldName(), i);
                switch (valueMeta.getType()) {
                    case 5: {
                        this.recordConsumer.addLong(valueMeta.getInteger(valueData).longValue());
                        break;
                    }
                    case 1: {
                        this.recordConsumer.addDouble(valueMeta.getNumber(valueData).doubleValue());
                        break;
                    }
                    case 4: {
                        this.recordConsumer.addBoolean(valueMeta.getBoolean(valueData).booleanValue());
                        break;
                    }
                    case 3: {
                        this.recordConsumer.addLong(valueMeta.getDate(valueData).getTime());
                        break;
                    }
                    case 8: {
                        byte[] bytes = valueMeta.getBinary(valueData);
                        this.recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])bytes));
                        break;
                    }
                    case 6: {
                        String bigString = valueMeta.getString(valueData);
                        this.recordConsumer.addBinary(Binary.fromString((String)bigString));
                        break;
                    }
                    default: {
                        this.recordConsumer.addBinary(Binary.fromString((String)valueMeta.getString(valueData)));
                    }
                }
                this.recordConsumer.endField(field.getTargetFieldName(), i);
            }
            this.recordConsumer.endMessage();
        }
        catch (HopException e) {
            throw new RuntimeException("Error writing row to Parquet", e);
        }
    }
}

