/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class InboundCounters {
    private volatile long errorCount;
    private volatile long errorBytes;
    private static final AtomicLongFieldUpdater<InboundCounters> errorCountUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "errorCount");
    private static final AtomicLongFieldUpdater<InboundCounters> errorBytesUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "errorBytes");
    private volatile long expiredCount;
    private volatile long expiredBytes;
    private static final AtomicLongFieldUpdater<InboundCounters> expiredCountUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "expiredCount");
    private static final AtomicLongFieldUpdater<InboundCounters> expiredBytesUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "expiredBytes");
    private volatile long processedCount;
    private volatile long processedBytes;
    private static final AtomicLongFieldUpdater<InboundCounters> processedCountUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "processedCount");
    private static final AtomicLongFieldUpdater<InboundCounters> processedBytesUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "processedBytes");
    private volatile long scheduledCount;
    private volatile long scheduledBytes;
    private static final AtomicLongFieldUpdater<InboundCounters> scheduledCountUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "scheduledCount");
    private static final AtomicLongFieldUpdater<InboundCounters> scheduledBytesUpdater = AtomicLongFieldUpdater.newUpdater(InboundCounters.class, "scheduledBytes");

    InboundCounters() {
    }

    void addError(int bytes) {
        errorCountUpdater.incrementAndGet(this);
        errorBytesUpdater.addAndGet(this, bytes);
    }

    long errorCount() {
        return this.errorCount;
    }

    long errorBytes() {
        return this.errorBytes;
    }

    void addExpired(int bytes) {
        expiredCountUpdater.incrementAndGet(this);
        expiredBytesUpdater.addAndGet(this, bytes);
    }

    long expiredCount() {
        return this.expiredCount;
    }

    long expiredBytes() {
        return this.expiredBytes;
    }

    void addProcessed(int bytes) {
        processedCountUpdater.incrementAndGet(this);
        processedBytesUpdater.addAndGet(this, bytes);
    }

    long processedCount() {
        return this.processedCount;
    }

    long processedBytes() {
        return this.processedBytes;
    }

    void addPending(int bytes) {
        scheduledCountUpdater.incrementAndGet(this);
        scheduledBytesUpdater.addAndGet(this, bytes);
    }

    void removePending(int bytes) {
        scheduledCountUpdater.decrementAndGet(this);
        scheduledBytesUpdater.addAndGet(this, -bytes);
    }

    long scheduledCount() {
        return this.scheduledCount;
    }

    long scheduledBytes() {
        return this.scheduledBytes;
    }
}

